/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.netmgt.provision.detector.icmp;

import java.util.Map;

import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.provision.support.GenericServiceDetectorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IcmpDetectorFactory extends GenericServiceDetectorFactory<IcmpDetector> {

    @Autowired(required=false)
    private PingerFactory pingerFactory;

    public IcmpDetectorFactory() {
        super(IcmpDetector.class);
    }

    @Override
    public IcmpDetector createDetector(Map<String, String> properties) {
        final IcmpDetector detector = new IcmpDetector();
        setBeanProperties(detector, properties);
        detector.setPingerFactory(pingerFactory);
        return detector;
    }

    public void setPingerFactory(PingerFactory pingerFactory) {
        this.pingerFactory = pingerFactory;
    }

}
