/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.opennms.netmgt.provision.persist.AbstractRequisitionVisitor;
import org.opennms.netmgt.provision.persist.OnmsAssetRequisition;
import org.opennms.netmgt.provision.persist.OnmsInterfaceMetaDataRequisition;
import org.opennms.netmgt.provision.persist.OnmsIpInterfaceRequisition;
import org.opennms.netmgt.provision.persist.OnmsMonitoredServiceRequisition;
import org.opennms.netmgt.provision.persist.OnmsNodeCategoryRequisition;
import org.opennms.netmgt.provision.persist.OnmsNodeMetaDataRequisition;
import org.opennms.netmgt.provision.persist.OnmsNodeRequisition;
import org.opennms.netmgt.provision.persist.OnmsServiceMetaDataRequisition;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.operations.ImportOperationsManager;
import org.opennms.netmgt.provision.service.operations.SaveOrUpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequisitionAccountant
extends AbstractRequisitionVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(RequisitionAccountant.class);
    private final ImportOperationsManager m_opsMgr;
    private SaveOrUpdateOperation m_currentOp;
    private String monitorKey;
    private final Set<CompletableFuture<Void>> m_dnsLookups = Collections.synchronizedSet(new HashSet());

    public RequisitionAccountant(ImportOperationsManager opsMgr, String monitorKey) {
        this.m_opsMgr = opsMgr;
        this.monitorKey = monitorKey;
    }

    public void visitNode(OnmsNodeRequisition nodeReq) {
        this.m_currentOp = this.m_opsMgr.foundNode(nodeReq.getForeignId(), nodeReq.getNodeLabel(), nodeReq.getLocation(), nodeReq.getBuilding(), nodeReq.getCity(), this.monitorKey);
    }

    public void completeNode(OnmsNodeRequisition nodeReq) {
        this.m_currentOp = null;
    }

    public void visitInterface(OnmsIpInterfaceRequisition ifaceReq) {
        this.m_currentOp.foundInterface(ifaceReq.getIpAddr(), ifaceReq.getDescr(), ifaceReq.getSnmpPrimary(), ifaceReq.getManaged(), ifaceReq.getStatus(), this.m_dnsLookups);
        LOG.debug("{} DNS lookups scheduled, {} DNS lookups completed", (Object)this.dnsLookupsTotal(), (Object)this.dnsLookupsCompleted());
    }

    public void visitMonitoredService(OnmsMonitoredServiceRequisition svcReq) {
        this.m_currentOp.foundMonitoredService(svcReq.getServiceName());
    }

    public void visitNodeCategory(OnmsNodeCategoryRequisition catReq) {
        this.m_currentOp.foundCategory(catReq.getName());
    }

    public void visitAsset(OnmsAssetRequisition assetReq) {
        this.m_currentOp.foundAsset(assetReq.getName(), assetReq.getValue());
    }

    public void visitNodeMetaData(OnmsNodeMetaDataRequisition metaDataReq) {
        this.m_currentOp.foundNodeMetaData(metaDataReq.getContext(), metaDataReq.getKey(), metaDataReq.getValue());
    }

    public void visitInterfaceMetaData(OnmsInterfaceMetaDataRequisition metaDataReq) {
        this.m_currentOp.foundInterfaceMetaData(metaDataReq.getContext(), metaDataReq.getKey(), metaDataReq.getValue());
    }

    public void visitServiceMetaData(OnmsServiceMetaDataRequisition metaDataReq) {
        this.m_currentOp.foundServiceMetaData(metaDataReq.getContext(), metaDataReq.getKey(), metaDataReq.getValue());
    }

    int dnsLookupsCompleted() {
        return (int)this.m_dnsLookups.stream().filter(f -> f.isDone()).count();
    }

    int dnsLookupsPending() {
        return this.dnsLookupsTotal() - this.dnsLookupsCompleted();
    }

    int dnsLookupsTotal() {
        return this.m_dnsLookups.size();
    }

    public void completeModelImport(Requisition req) {
        LOG.debug("Waiting for {} scheduled DNS lookups, {} DNS lookups pending", (Object)this.dnsLookupsTotal(), (Object)this.dnsLookupsPending());
        this.m_dnsLookups.stream().map(CompletableFuture::join);
        LOG.debug("All {} scheduled DNS lookups completed", (Object)this.dnsLookupsTotal());
    }
}

