/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.processing;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.StringWriter;
import java.util.Objects;
import org.opennms.netmgt.flows.api.ConversationKey;

public class ConversationKeyUtils {
    private static final Gson gson = new GsonBuilder().create();

    public static ConversationKey fromJsonString(String json) {
        Object[] array = (Object[])gson.fromJson(json, Object[].class);
        if (array.length != 5) {
            throw new IllegalArgumentException("Invalid conversation key string: " + json);
        }
        return new ConversationKey((String)array[0], Integer.valueOf(((Number)array[1]).intValue()), (String)array[2], (String)array[3], (String)array[4]);
    }

    public static String getConvoKeyAsJsonString(String location, Integer protocol, String srcAddr, String dstAddr, String application) {
        if (location != null && protocol != null && srcAddr != null && dstAddr != null) {
            StringWriter writer = new StringWriter();
            writer.write("[");
            writer.write(gson.toJson((Object)location));
            writer.write(",");
            writer.write(Integer.toString(protocol));
            writer.write(",");
            if (Objects.compare(srcAddr, dstAddr, String::compareTo) < 0) {
                writer.write(gson.toJson((Object)srcAddr));
                writer.write(",");
                writer.write(gson.toJson((Object)dstAddr));
            } else {
                writer.write(gson.toJson((Object)dstAddr));
                writer.write(",");
                writer.write(gson.toJson((Object)srcAddr));
            }
            writer.write(",");
            if (application != null) {
                writer.write(gson.toJson((Object)application));
            } else {
                writer.write("null");
            }
            writer.write("]");
            return writer.toString();
        }
        return null;
    }
}

