/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.model.CdpElement;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.ErrorStatus;
import org.opennms.netmgt.snmp.ErrorStatusException;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpGlobalGroupTracker
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CdpGlobalGroupTracker.class);
    public static final String CDP_GLOBAL_RUN = "cdpGlobalRun";
    public static final String CDP_GLOBAL_DEVICEID = "cdpGlobalDeviceId";
    public static final String CDP_GLOBAL_DEVICEID_FORMAT = "cdpGlobalDeviceIdFormat";
    public static final String CDP_GLOBAL_RUN_OID = ".1.3.6.1.4.1.9.9.23.1.3.1";
    public static final String CDP_GLOBAL_DEVICEID_OID = ".1.3.6.1.4.1.9.9.23.1.3.4";
    public static final String CDP_GLOBAL_DEVICEID_FORMAT_OID = ".1.3.6.1.4.1.9.9.23.1.3.7";
    public static final NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpGlobalRun", ".1.3.6.1.4.1.9.9.23.1.3.1"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpGlobalDeviceId", ".1.3.6.1.4.1.9.9.23.1.3.4"), new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", "cdpGlobalDeviceIdFormat", ".1.3.6.1.4.1.9.9.23.1.3.7")};
    private final SnmpStore m_store = new SnmpStore(ms_elemList);

    public CdpGlobalGroupTracker() {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving CDP global group: {}", (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving CDP global group: {}", (Object)msg);
    }

    protected void reportFatalErr(ErrorStatusException ex) {
        LOG.warn("Fatal error retrieving CDP global group: {}", (Object)ex.getMessage(), (Object)ex);
    }

    protected void reportNonFatalErr(ErrorStatus status) {
        LOG.info("Non-fatal error ({}) retrieving CDP global group: {}", (Object)status, (Object)(status.retry() ? "Retrying." : "Giving up."));
    }

    public String getCdpDeviceId() {
        return this.m_store.getDisplayString(CDP_GLOBAL_DEVICEID);
    }

    public Integer getCdpGlobalRun() {
        return this.m_store.getInt32(CDP_GLOBAL_RUN);
    }

    public Integer getCdpGlobalDeviceFormat() {
        return this.m_store.getInt32(CDP_GLOBAL_DEVICEID_FORMAT);
    }

    public CdpElement getCdpElement() {
        CdpElement cdpElement = new CdpElement();
        cdpElement.setCdpGlobalRun(OspfElement.TruthValue.get((Integer)this.getCdpGlobalRun()));
        cdpElement.setCdpGlobalDeviceId(this.getCdpDeviceId());
        if (this.getCdpGlobalDeviceFormat() != null) {
            try {
                cdpElement.setCdpGlobalDeviceIdFormat(CdpElement.CdpGlobalDeviceIdFormat.get((Integer)this.getCdpGlobalDeviceFormat()));
            }
            catch (IllegalArgumentException e) {
                LOG.info("setCdpGlobalDeviceIdFormat not supported: {}", (Object)e.getLocalizedMessage());
            }
        }
        return cdpElement;
    }

    public void printSnmpData() {
        System.out.printf("\t\t%s (%s)= %s (%s)\n", CDP_GLOBAL_RUN_OID, CDP_GLOBAL_RUN, this.getCdpGlobalRun(), OspfElement.TruthValue.get((Integer)this.getCdpGlobalRun()));
        System.out.printf("\t\t%s (%s)= %s\n", CDP_GLOBAL_DEVICEID_OID, CDP_GLOBAL_DEVICEID, this.getCdpDeviceId());
        if (this.getCdpGlobalDeviceFormat() == null) {
            System.out.printf("\t\t%s (%s)= (no value found)\n", CDP_GLOBAL_DEVICEID_FORMAT_OID, CDP_GLOBAL_DEVICEID_FORMAT);
        } else {
            System.out.printf("\t\t%s (%s)= %s (%s)\n", CDP_GLOBAL_DEVICEID_FORMAT_OID, CDP_GLOBAL_DEVICEID_FORMAT, this.getCdpGlobalDeviceFormat(), CdpElement.CdpGlobalDeviceIdFormat.getTypeString((Integer)this.getCdpGlobalDeviceFormat()));
        }
    }
}

