/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;

public class LargeCommunities
implements Attribute {
    public final List<LargeCommunity> largeCommunities;

    public LargeCommunities(ByteBuf buffer, PeerFlags flags) {
        this.largeCommunities = BufferUtils.repeatRemaining((ByteBuf)buffer, LargeCommunity::new);
    }

    @Override
    public void accept(Attribute.Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("largeCommunities", this.largeCommunities).toString();
    }

    public static class LargeCommunity {
        public final long globalAdministrator;
        public final long localDataPart1;
        public final long localDataPart2;

        public LargeCommunity(ByteBuf buffer) {
            this.globalAdministrator = BufferUtils.uint32((ByteBuf)buffer);
            this.localDataPart1 = BufferUtils.uint32((ByteBuf)buffer);
            this.localDataPart2 = BufferUtils.uint32((ByteBuf)buffer);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("globalAdministrator", this.globalAdministrator).add("localDataPart1", this.localDataPart1).add("localDataPart2", this.localDataPart2).toString();
        }
    }
}

