/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.generic.client;

import java.io.IOException;
import java.net.InetAddress;
import org.opennms.core.utils.ExecRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.provision.ScriptUtil;
import org.opennms.netmgt.provision.detector.generic.request.GpRequest;
import org.opennms.netmgt.provision.detector.generic.response.GpResponse;
import org.opennms.netmgt.provision.support.Client;

public class GpClient
implements Client<GpRequest, GpResponse> {
    private String m_script;
    private String m_args;
    private String m_banner;
    private String m_match;
    private String m_hoption;
    private String m_toption;
    private int m_exitStatus = 100;
    private String m_response = "";
    private String m_error = "";

    public void close() {
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        this.setExitStatus(100);
        ExecRunner execRunner = new ExecRunner();
        execRunner.setMaxRunTimeSecs(this.convertToSeconds(timeout));
        String hostAddress = InetAddressUtils.str((InetAddress)address);
        if (!ScriptUtil.isDescendantOf((String)System.getProperty("opennms.home"), (String)this.getScript())) {
            throw new IOException("The location of the script must not be outside $OPENNMS_HOME.");
        }
        String script = this.getScript() + " " + this.getHoption() + " " + hostAddress + " " + this.getToption() + " " + this.convertToSeconds(timeout);
        if (this.getArgs() == null) {
            this.setExitStatus(execRunner.exec(script));
        } else {
            this.setExitStatus(execRunner.exec(this.getScript() + " " + this.getHoption() + " " + hostAddress + " " + this.getToption() + " " + this.convertToSeconds(timeout) + " " + this.getArgs()));
        }
        if (!execRunner.isMaxRunTimeExceeded() && this.getExitStatus() == 0) {
            this.setResponse(execRunner.getOutString());
            this.setError(execRunner.getErrString());
        }
    }

    private int convertToSeconds(int timeout) {
        timeout = timeout > 0 && timeout < 1000 ? 1 : (timeout /= 1000);
        return timeout;
    }

    public GpResponse receiveBanner() throws IOException, Exception {
        return this.receiveResponse();
    }

    private GpResponse receiveResponse() {
        GpResponse response = new GpResponse();
        response.setExitStatus(this.getExitStatus());
        response.setResponse(this.getResponse());
        response.setError(this.getError());
        return response;
    }

    public GpResponse sendRequest(GpRequest request) throws IOException, Exception {
        return null;
    }

    public void setScript(String script) {
        this.m_script = script;
    }

    public String getScript() {
        return this.m_script;
    }

    public void setArgs(String args) {
        this.m_args = args;
    }

    public String getArgs() {
        return this.m_args;
    }

    public void setBanner(String banner) {
        this.m_banner = banner;
    }

    public String getBanner() {
        return this.m_banner;
    }

    public void setMatch(String match) {
        this.m_match = match;
    }

    public String getMatch() {
        return this.m_match;
    }

    public void setHoption(String hoption) {
        this.m_hoption = hoption;
    }

    public String getHoption() {
        return this.m_hoption;
    }

    public void setToption(String toption) {
        this.m_toption = toption;
    }

    public String getToption() {
        return this.m_toption;
    }

    public void setExitStatus(int exitStatus) {
        this.m_exitStatus = exitStatus;
    }

    public int getExitStatus() {
        return this.m_exitStatus;
    }

    public void setResponse(String response) {
        this.m_response = response;
    }

    public String getResponse() {
        return this.m_response;
    }

    public void setError(String error) {
        this.m_error = error;
    }

    public String getError() {
        return this.m_error;
    }
}

