/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy.strategy;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.icmp.proxy.PingRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingResponse;
import org.opennms.netmgt.icmp.proxy.PingResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingSummary;
import org.opennms.netmgt.icmp.proxy.strategy.ExecutionStrategy;

public class SinglePingExecutionStrategy
implements ExecutionStrategy {
    private final RpcClient<PingRequestDTO, PingResponseDTO> client;

    public SinglePingExecutionStrategy(RpcClient<PingRequestDTO, PingResponseDTO> client) {
        this.client = Objects.requireNonNull(client);
    }

    @Override
    public CompletableFuture<PingSummary> execute(PingRequestDTO requestDTO) {
        return this.client.execute((RpcRequest)requestDTO).thenApply(responseDTO -> {
            PingResponse pingResponse = new PingResponse();
            pingResponse.setRtt(responseDTO.getRtt());
            PingSummary summary = new PingSummary(requestDTO.toPingRequest(), 1);
            summary.addSequence(1, pingResponse);
            return summary;
        });
    }
}

