/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vaadin.core;

import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.Label;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UIHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UIHelper.class);
    public static int DEFAULT_NOTIFICATION_DELAY = 3000;

    public static Button createButton(String buttonCaption, String buttonDescription, Resource icon, Button.ClickListener clickListener) {
        Button button = new Button();
        button.setCaption(buttonCaption);
        button.setIcon(icon);
        if (buttonDescription != null) {
            button.setDescription(buttonDescription);
        }
        if (clickListener != null) {
            button.addClickListener(clickListener);
        }
        return button;
    }

    public static Label createLabel(String caption, String content) {
        Label label = new Label(content);
        label.setCaption(caption);
        return label;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String loadContentFromFile(Class<?> clazz, String resourceName) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(resourceName);
        try (InputStream is = clazz.getResourceAsStream(resourceName);){
            String string;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                LOG.debug("Resource '{}' loaded from class '{}': '{}'", new Object[]{resourceName, clazz.getName(), is});
                if (is == null) {
                    throw new NullPointerException(String.format("Resource '%s' not available", resourceName));
                }
                ByteStreams.copy((InputStream)is, (OutputStream)outputStream);
                string = outputStream.toString();
            }
            return string;
        }
        catch (IOException e) {
            LOG.error("Error while reading resource from '{}'.", (Object)resourceName, (Object)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void showValidationError(String errorMessage) {
        UIHelper.showNotification("Validation Error", errorMessage != null ? errorMessage : "An unknown error occurred.", Notification.Type.ERROR_MESSAGE);
    }

    public static <T extends UI> T getCurrent(Class<T> clazz) {
        UI ui = UI.getCurrent();
        if (ui == null || !ui.isAttached()) {
            throw new IllegalStateException("UI is either null or not attached. Ensure it is invoked from within a VaadinRequest");
        }
        return (T)ui;
    }

    public static void showNotification(String message) {
        UIHelper.showNotification(message, null, Notification.Type.ERROR_MESSAGE);
    }

    public static void showNotification(String title, String message, Notification.Type type) {
        UIHelper.showNotification(title, message, type, DEFAULT_NOTIFICATION_DELAY);
    }

    public static void showNotification(String title, String message, Notification.Type type, int delayMsec) {
        Notification notification = new Notification(title, message, type, true);
        notification.setDelayMsec(delayMsec);
        notification.show(Page.getCurrent());
    }

    public static void validateField(Field<?> field, boolean swallowValidationExceptions) throws Validator.InvalidValueException {
        block4: {
            if (field instanceof AbstractComponent && field.isEnabled()) {
                try {
                    field.validate();
                    ((AbstractComponent)field).setComponentError(null);
                }
                catch (Validator.InvalidValueException ex) {
                    if (ex.getMessage() == null) {
                        ex = ex.getCauses()[0];
                    }
                    ((AbstractComponent)field).setComponentError((ErrorMessage)new UserError(ex.getMessage()));
                    if (swallowValidationExceptions) break block4;
                    throw ex;
                }
            }
        }
    }

    public static void validateFields(Collection<Field<?>> fields, boolean swallowValidationExceptions) {
        for (Field<?> eachField : fields) {
            UIHelper.validateField(eachField, swallowValidationExceptions);
        }
    }
}

