/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.tx.control.service.common.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.osgi.service.transaction.control.TransactionContext;
import org.osgi.service.transaction.control.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionContextImpl
implements TransactionContext {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTransactionContextImpl.class);
    protected final AtomicReference<Throwable> firstUnexpectedException = new AtomicReference();
    protected final List<Throwable> subsequentExceptions = new ArrayList<Throwable>();
    protected final Set<Throwable> ignoredExceptions = Collections.newSetFromMap(new IdentityHashMap());
    protected final List<Runnable> preCompletion = new ArrayList<Runnable>();
    protected final List<Consumer<TransactionStatus>> postCompletion = new ArrayList<Consumer<TransactionStatus>>();
    protected final Map<Object, Object> scopedVariables = new HashMap<Object, Object>();

    @Override
    public Object getScopedValue(Object key) {
        return this.scopedVariables.get(key);
    }

    @Override
    public void putScopedValue(Object key, Object value) {
        this.scopedVariables.put(key, value);
    }

    protected void beforeCompletion(Runnable onFirstError) {
        this.preCompletion.stream().forEach(r -> {
            try {
                r.run();
            }
            catch (Exception e) {
                if (this.firstUnexpectedException.compareAndSet(null, e)) {
                    onFirstError.run();
                } else {
                    this.subsequentExceptions.add(e);
                }
                logger.warn("A pre-completion callback failed with an exception", (Throwable)e);
            }
        });
    }

    protected void afterCompletion(TransactionStatus status) {
        this.postCompletion.stream().forEach(c -> {
            try {
                c.accept(status);
            }
            catch (Exception e) {
                logger.warn("A post-completion callback failed with an exception", (Throwable)e);
            }
        });
    }

    protected abstract boolean isAlive();

    protected void recordFailure(Throwable failure) {
        if (!this.firstUnexpectedException.compareAndSet(null, failure)) {
            this.subsequentExceptions.add(failure);
        }
    }

    protected abstract void safeSetRollbackOnly();

    public abstract void finish();

    protected void ignoreException(Throwable t) {
        this.ignoredExceptions.add(t);
    }
}

