/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.portlet.ClientDataRequest;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.WindowState;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.portlet.bind.PortletRequestBindingException;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;
import org.springframework.web.portlet.handler.PortletRequestMethodNotSupportedException;
import org.springframework.web.portlet.mvc.annotation.PortletAnnotationMappingUtils;

public class DefaultAnnotationHandlerMapping
extends AbstractMapBasedHandlerMapping<PortletMode> {
    @Override
    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.detectHandlers();
    }

    protected void detectHandlers() throws BeansException {
        String[] beanNames;
        ApplicationContext context = this.getApplicationContext();
        for (String beanName : beanNames = context.getBeanNamesForType(Object.class)) {
            Class handlerType = context.getType(beanName);
            RequestMapping mapping = (RequestMapping)context.findAnnotationOnBean(beanName, RequestMapping.class);
            if (mapping != null) {
                String[] modeKeys = mapping.value();
                String[] params = mapping.params();
                boolean registerHandlerType = true;
                if (modeKeys.length == 0 || params.length == 0) {
                    boolean bl = registerHandlerType = !this.detectHandlerMethods(handlerType, beanName, mapping);
                }
                if (!registerHandlerType) continue;
                TypeLevelMappingPredicate predicate = new TypeLevelMappingPredicate(params, mapping.headers(), mapping.method());
                for (String modeKey : modeKeys) {
                    this.registerHandler(new PortletMode(modeKey), beanName, predicate);
                }
                continue;
            }
            if (AnnotationUtils.findAnnotation((Class)handlerType, Controller.class) == null) continue;
            this.detectHandlerMethods(handlerType, beanName, mapping);
        }
    }

    protected boolean detectHandlerMethods(Class<?> handlerType, final String beanName, final RequestMapping typeMapping) {
        final HashSet handlersRegistered = new HashSet(1);
        LinkedHashSet handlerTypes = new LinkedHashSet();
        handlerTypes.add(handlerType);
        handlerTypes.addAll(Arrays.asList(handlerType.getInterfaces()));
        for (Class clazz : handlerTypes) {
            ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate predicate = null;
                    String[] modeKeys = new String[]{};
                    String[] params = new String[]{};
                    if (typeMapping != null) {
                        params = StringUtils.mergeStringArrays((String[])typeMapping.params(), (String[])params);
                    }
                    ActionMapping actionMapping = (ActionMapping)AnnotationUtils.findAnnotation((Method)method, ActionMapping.class);
                    RenderMapping renderMapping = (RenderMapping)AnnotationUtils.findAnnotation((Method)method, RenderMapping.class);
                    ResourceMapping resourceMapping = (ResourceMapping)AnnotationUtils.findAnnotation((Method)method, ResourceMapping.class);
                    EventMapping eventMapping = (EventMapping)AnnotationUtils.findAnnotation((Method)method, EventMapping.class);
                    RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
                    if (actionMapping != null) {
                        params = StringUtils.mergeStringArrays((String[])params, (String[])actionMapping.params());
                        predicate = new ActionMappingPredicate(actionMapping.name(), params);
                    } else if (renderMapping != null) {
                        params = StringUtils.mergeStringArrays((String[])params, (String[])renderMapping.params());
                        predicate = new RenderMappingPredicate(renderMapping.windowState(), params);
                    } else if (resourceMapping != null) {
                        predicate = new ResourceMappingPredicate(resourceMapping.value());
                    } else if (eventMapping != null) {
                        predicate = new EventMappingPredicate(eventMapping.value());
                    }
                    if (requestMapping != null) {
                        modeKeys = requestMapping.value();
                        if (typeMapping != null && !PortletAnnotationMappingUtils.validateModeMapping(modeKeys, typeMapping.value())) {
                            throw new IllegalStateException("Mode mappings conflict between method and type level: " + Arrays.asList(modeKeys) + " versus " + Arrays.asList(typeMapping.value()));
                        }
                        params = StringUtils.mergeStringArrays((String[])params, (String[])requestMapping.params());
                        if (predicate == null) {
                            predicate = new MethodLevelMappingPredicate(params);
                        }
                    }
                    if (predicate != null) {
                        if (modeKeys.length == 0) {
                            if (typeMapping != null) {
                                modeKeys = typeMapping.value();
                            }
                            if (modeKeys.length == 0) {
                                throw new IllegalStateException("No portlet mode mappings specified - neither at type nor at method level");
                            }
                        }
                        for (String modeKey : modeKeys) {
                            DefaultAnnotationHandlerMapping.this.registerHandler(new PortletMode(modeKey), beanName, predicate);
                            handlersRegistered.add(Boolean.TRUE);
                        }
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return !handlersRegistered.isEmpty();
    }

    @Override
    protected PortletMode getLookupKey(PortletRequest request) throws Exception {
        return request.getPortletMode();
    }

    private static class EventMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate,
    SpecialRequestTypePredicate {
        private final String eventName;

        public EventMappingPredicate(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public boolean match(PortletRequest request) {
            if (!"EVENT_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase"))) {
                return false;
            }
            if ("".equals(this.eventName)) {
                return true;
            }
            Event event = ((EventRequest)request).getEvent();
            return this.eventName.equals(event.getName()) || this.eventName.equals(event.getQName().toString());
        }

        @Override
        public void validate(PortletRequest request) {
        }

        @Override
        public int compareTo(AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate other) {
            if (other instanceof EventMappingPredicate) {
                boolean otherHasEventName;
                boolean hasEventName = !"".equals(this.eventName);
                boolean bl = otherHasEventName = !"".equals(((EventMappingPredicate)other).eventName);
                if (hasEventName != otherHasEventName) {
                    return hasEventName ? -1 : 1;
                }
            }
            if (other instanceof SpecialRequestTypePredicate) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            return -1;
        }
    }

    private static class ResourceMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate,
    SpecialRequestTypePredicate {
        private final String resourceId;

        public ResourceMappingPredicate(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public boolean match(PortletRequest request) {
            return "RESOURCE_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase")) && ("".equals(this.resourceId) || this.resourceId.equals(((ResourceRequest)request).getResourceID()));
        }

        @Override
        public void validate(PortletRequest request) {
        }

        @Override
        public int compareTo(AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate other) {
            if (other instanceof ResourceMappingPredicate) {
                boolean otherHasResourceId;
                boolean hasResourceId = !"".equals(this.resourceId);
                boolean bl = otherHasResourceId = !"".equals(((ResourceMappingPredicate)other).resourceId);
                if (hasResourceId != otherHasResourceId) {
                    return hasResourceId ? -1 : 1;
                }
            }
            if (other instanceof SpecialRequestTypePredicate) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            return -1;
        }
    }

    private static class RenderMappingPredicate
    extends AbstractParameterMappingPredicate
    implements SpecialRequestTypePredicate {
        private final WindowState windowState;

        public RenderMappingPredicate(String windowState, String[] params) {
            super(params);
            this.windowState = "".equals(windowState) ? null : new WindowState(windowState);
        }

        @Override
        public boolean match(PortletRequest request) {
            return "RENDER_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase")) && (this.windowState == null || this.windowState.equals((Object)request.getWindowState())) && super.match(request);
        }

        @Override
        public void validate(PortletRequest request) {
        }

        @Override
        public int compareTo(AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate other) {
            if (other instanceof TypeLevelMappingPredicate) {
                return 1;
            }
            if (other instanceof RenderMappingPredicate) {
                boolean otherHasWindowState;
                RenderMappingPredicate otherRender = (RenderMappingPredicate)other;
                boolean hasWindowState = this.windowState != null;
                boolean bl = otherHasWindowState = otherRender.windowState != null;
                if (hasWindowState != otherHasWindowState) {
                    return hasWindowState ? -1 : 1;
                }
                return this.compareParams(otherRender);
            }
            if (other instanceof SpecialRequestTypePredicate) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            return -1;
        }
    }

    private static class ActionMappingPredicate
    extends AbstractParameterMappingPredicate
    implements SpecialRequestTypePredicate {
        private final String actionName;

        public ActionMappingPredicate(String actionName, String[] params) {
            super(params);
            this.actionName = actionName;
        }

        @Override
        public boolean match(PortletRequest request) {
            return "ACTION_PHASE".equals(request.getAttribute("javax.portlet.lifecycle_phase")) && ("".equals(this.actionName) || this.actionName.equals(request.getParameter("javax.portlet.action"))) && super.match(request);
        }

        @Override
        public void validate(PortletRequest request) {
        }

        @Override
        public int compareTo(AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate other) {
            if (other instanceof TypeLevelMappingPredicate) {
                return 1;
            }
            if (other instanceof ActionMappingPredicate) {
                boolean otherHasActionName;
                ActionMappingPredicate otherAction = (ActionMappingPredicate)other;
                boolean hasActionName = "".equals(this.actionName);
                if (hasActionName != (otherHasActionName = "".equals(otherAction.actionName))) {
                    return hasActionName ? -1 : 1;
                }
                return this.compareParams(otherAction);
            }
            if (other instanceof SpecialRequestTypePredicate) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            return -1;
        }
    }

    private static class MethodLevelMappingPredicate
    extends AbstractParameterMappingPredicate {
        public MethodLevelMappingPredicate(String[] params) {
            super(params);
        }

        @Override
        public void validate(PortletRequest request) throws PortletException {
        }

        @Override
        public int compareTo(AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate other) {
            return other instanceof SpecialRequestTypePredicate ? 1 : this.compareParams(other);
        }
    }

    private static class TypeLevelMappingPredicate
    extends AbstractParameterMappingPredicate {
        private final String[] headers;
        private final Set<String> methods = new HashSet<String>();

        public TypeLevelMappingPredicate(String[] params, String[] headers, RequestMethod[] methods) {
            super(params);
            this.headers = headers;
            if (methods != null) {
                for (RequestMethod method : methods) {
                    this.methods.add(method.name());
                }
            }
        }

        @Override
        public void validate(PortletRequest request) throws PortletException {
            if (!PortletAnnotationMappingUtils.checkHeaders(this.headers, request)) {
                throw new PortletRequestBindingException("Header conditions \"" + StringUtils.arrayToDelimitedString((Object[])this.headers, (String)", ") + "\" not met for actual request");
            }
            if (!this.methods.isEmpty()) {
                if (!(request instanceof ClientDataRequest)) {
                    throw new PortletRequestMethodNotSupportedException(StringUtils.toStringArray(this.methods));
                }
                String method = ((ClientDataRequest)request).getMethod();
                if (!this.methods.contains(method)) {
                    throw new PortletRequestMethodNotSupportedException(method, StringUtils.toStringArray(this.methods));
                }
            }
        }

        @Override
        public int compareTo(AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate other) {
            return other instanceof SpecialRequestTypePredicate ? -1 : this.compareParams(other);
        }
    }

    private static abstract class AbstractParameterMappingPredicate
    implements AbstractMapBasedHandlerMapping.PortletRequestMappingPredicate {
        private final String[] params;

        public AbstractParameterMappingPredicate(String[] params) {
            this.params = params;
        }

        @Override
        public boolean match(PortletRequest request) {
            return PortletAnnotationMappingUtils.checkParameters(this.params, request);
        }

        protected int compareParams(AbstractParameterMappingPredicate other) {
            return new Integer(other.params.length).compareTo(this.params.length);
        }

        protected int compareParams(Object other) {
            if (other instanceof AbstractParameterMappingPredicate) {
                return this.compareParams((AbstractParameterMappingPredicate)other);
            }
            return 0;
        }
    }

    private static interface SpecialRequestTypePredicate {
    }
}

