/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.policies;

import com.google.common.base.Strings;
import java.util.Map;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.BasePolicy;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.annotations.Policy;
import org.opennms.netmgt.provision.annotations.Require;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Policy(value="Set Node Metadata")
public class NodeMetadataSettingPolicy
extends BasePolicy<OnmsNode>
implements NodePolicy {
    private String metadataContext = "requisition";
    private String metadataKey;
    private String metadataValue = "";

    public OnmsNode act(OnmsNode node, Map<String, Object> attributes) {
        if (Strings.isNullOrEmpty((String)this.metadataKey) || Strings.isNullOrEmpty((String)this.metadataContext)) {
            return node;
        }
        node.addRequisionedMetaData(new OnmsMetaData(this.metadataContext, this.metadataKey, this.metadataValue != null ? this.metadataValue : ""));
        return node;
    }

    public void setMetadataKey(String metadataKey) {
        this.metadataKey = metadataKey;
    }

    @Require(value={})
    public String getMetadataKey() {
        return this.metadataKey;
    }

    public void setMetadataValue(String metadataValue) {
        this.metadataValue = metadataValue;
    }

    @Require(value={})
    public String getMetadataValue() {
        return this.metadataValue;
    }

    public void setMetadataContext(String metadataContext) {
        this.metadataContext = metadataContext;
    }

    public String getMetadataContext() {
        return this.metadataContext;
    }

    public String getType() {
        return this.getCriteria("type");
    }

    public void setType(String type) {
        this.putCriteria("type", type);
    }

    public String getSysObjectId() {
        return this.getCriteria("sysObjectId");
    }

    public void setSysObjectId(String sysObjectId) {
        this.putCriteria("sysObjectId", sysObjectId);
    }

    public String getSysName() {
        return this.getCriteria("sysName");
    }

    public void setSysName(String sysName) {
        this.putCriteria("sysName", sysName);
    }

    public String getSysDescription() {
        return this.getCriteria("sysDescription");
    }

    public void setSysDescription(String sysDescription) {
        this.putCriteria("sysDescription", sysDescription);
    }

    public String getSysLocation() {
        return this.getCriteria("sysLocation");
    }

    public void setSysLocation(String sysLocation) {
        this.putCriteria("sysLocation", sysLocation);
    }

    public String getSysContact() {
        return this.getCriteria("sysContact");
    }

    public void setSysContact(String sysContact) {
        this.putCriteria("sysContact", sysContact);
    }

    public String getLabel() {
        return this.getCriteria("label");
    }

    public void setLabel(String label) {
        this.putCriteria("label", label);
    }

    public String getLabelSource() {
        return this.getCriteria("labelSource");
    }

    public void setLabelSource(String labelSource) {
        this.putCriteria("labelSource", labelSource);
    }

    public String getNetBiosName() {
        return this.getCriteria("netBiosName");
    }

    public void setNetBiosName(String netBiosName) {
        this.putCriteria("netBiosName", netBiosName);
    }

    public String getNetBiosDomain() {
        return this.getCriteria("netBiosDomain");
    }

    public void setNetBiosDomain(String netBiosDomain) {
        this.putCriteria("netBiosDomain", netBiosDomain);
    }

    public String getOperatingSystem() {
        return this.getCriteria("operatingSystem");
    }

    public void setOperatingSystem(String operatingSystem) {
        this.putCriteria("operatingSystem", operatingSystem);
    }

    public String getForeignId() {
        return this.getCriteria("foreignId");
    }

    public void setForeignId(String foreignId) {
        this.putCriteria("foreignId", foreignId);
    }

    public String getForeignSource() {
        return this.getCriteria("foreignSource");
    }

    public void setForeignSource(String foreignSource) {
        this.putCriteria("foreignSource", foreignSource);
    }
}

