/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.datagram;

import java.io.IOException;
import java.net.DatagramPacket;
import org.opennms.netmgt.provision.detector.datagram.client.DatagramClient;
import org.opennms.netmgt.provision.support.BasicDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.opennms.netmgt.provision.support.dns.DNSAddressRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsDetector
extends BasicDetector<DatagramPacket, DatagramPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(DnsDetector.class);
    private static final String DEFAULT_SERVICE_NAME = "DNS";
    private static final int DEFAULT_PORT = 53;
    private static final String DEFAULT_LOOKUP = "localhost";
    private String m_lookup = "localhost";

    public DnsDetector() {
        super(DEFAULT_SERVICE_NAME, 53);
    }

    public DnsDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    protected void onInit() {
        DNSAddressRequest req = DnsDetector.addrRequest(this.getLookup());
        this.send(DnsDetector.encode(req), DnsDetector.verifyResponse(req));
    }

    private static ResponseValidator<DatagramPacket> verifyResponse(final DNSAddressRequest request) {
        return new ResponseValidator<DatagramPacket>(){

            public boolean validate(DatagramPacket response) {
                try {
                    request.verifyResponse(response.getData(), response.getLength());
                }
                catch (IOException e) {
                    LOG.info("failed to connect", (Throwable)e);
                    return false;
                }
                return true;
            }
        };
    }

    private static DNSAddressRequest addrRequest(String host) {
        return new DNSAddressRequest(host);
    }

    private static DatagramPacket encode(DNSAddressRequest dnsPacket) {
        byte[] data = DnsDetector.buildRequest(dnsPacket);
        return new DatagramPacket(data, data.length);
    }

    private static byte[] buildRequest(DNSAddressRequest request) {
        try {
            return request.buildRequest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to build dnsRequest!!! This shouldn't happen!!");
        }
    }

    protected Client<DatagramPacket, DatagramPacket> getClient() {
        return new DatagramClient();
    }

    public void setLookup(String lookup) {
        this.m_lookup = lookup;
    }

    public String getLookup() {
        return this.m_lookup;
    }
}

