/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.LatencyCollectionAttribute;
import org.opennms.netmgt.collection.api.LatencyCollectionAttributeType;
import org.opennms.netmgt.collection.api.LatencyCollectionResource;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.SingleResourceCollectionSet;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyStoringServiceMonitorAdaptor
implements ServiceMonitorAdaptor {
    private static final Logger LOG = LoggerFactory.getLogger(LatencyStoringServiceMonitorAdaptor.class);
    public static final int HEARTBEAT_STEP_MULTIPLIER = 2;
    private static final ServiceParameters EMPTY_SERVICE_PARAMS = new ServiceParameters(Collections.emptyMap());
    private PollerConfig m_pollerConfig;
    private Package m_pkg;
    private final PersisterFactory m_persisterFactory;
    private final ThresholdingService m_thresholdingService;
    private ThresholdingSession m_thresholdingSession;

    public LatencyStoringServiceMonitorAdaptor(PollerConfig config, Package pkg, PersisterFactory persisterFactory, ThresholdingService thresholdingService) {
        this.m_pollerConfig = config;
        this.m_pkg = pkg;
        this.m_persisterFactory = persisterFactory;
        this.m_thresholdingService = thresholdingService;
    }

    @Override
    public PollStatus handlePollResult(MonitoredService svc, Map<String, Object> parameters, PollStatus status) {
        if (!status.getProperties().isEmpty()) {
            this.storeResponseTime(svc, new LinkedHashMap<String, Number>(status.getProperties()), parameters);
        }
        return status;
    }

    private void storeResponseTime(MonitoredService svc, Map<String, Number> entries, Map<String, Object> parameters) {
        String rrdPath = ParameterMap.getKeyedString(parameters, (String)"rrd-repository", null);
        String dsName = ParameterMap.getKeyedString(parameters, (String)"ds-name", (String)svc.getSvcName().toLowerCase());
        String rrdBaseName = ParameterMap.getKeyedString(parameters, (String)"rrd-base-name", (String)dsName);
        String thresholds = ParameterMap.getKeyedString(parameters, (String)"thresholding-enabled", (String)"false");
        boolean snmpInfoInTags = ParameterMap.getKeyedBoolean(parameters, (String)"interface-info-in-tags", (boolean)false);
        if (!entries.containsKey(dsName) && entries.containsKey("response-time")) {
            entries.put(dsName, entries.get("response-time"));
            entries.remove("response-time");
        }
        if (rrdPath == null) {
            LOG.debug("storeResponseTime: RRD repository not specified in parameters, latency data will not be stored.");
            return;
        }
        CollectionSet collectionSet = this.getCollectionSet(svc, entries, rrdBaseName, snmpInfoInTags);
        RrdRepository repository = this.getRrdRepository(rrdPath);
        if (thresholds.equalsIgnoreCase("true")) {
            this.applyThresholds(collectionSet, svc, dsName);
        } else {
            LOG.debug("storeResponseTime: Thresholds processing is not enabled. Check thresholding-enabled parameter on service definition");
        }
        LOG.debug("storeResponseTime: Persisting latency data for {}", (Object)svc);
        this.persistCollectionSet(collectionSet, repository);
    }

    private RrdRepository getRrdRepository(String rrdPath) {
        File rrdRepositoryRoot = new File(rrdPath);
        RrdRepository repository = new RrdRepository();
        repository.setStep(this.m_pollerConfig.getStep(this.m_pkg));
        repository.setRraList(this.m_pollerConfig.getRRAList(this.m_pkg));
        repository.setHeartBeat(repository.getStep() * 2);
        repository.setRrdBaseDir(rrdRepositoryRoot);
        return repository;
    }

    private void persistCollectionSet(CollectionSet collectionSet, RrdRepository repository) {
        ServiceParameters params = new ServiceParameters(Collections.emptyMap());
        Persister persister = this.m_persisterFactory.createPersister(params, repository, false, true, true);
        collectionSet.visit((CollectionSetVisitor)persister);
    }

    private void applyThresholds(CollectionSet collectionSet, MonitoredService service, String dsName) {
        try {
            if (this.m_thresholdingSession == null) {
                this.m_thresholdingSession = this.m_thresholdingService.createSession(service.getNodeId(), service.getIpAddr(), service.getSvcName(), EMPTY_SERVICE_PARAMS);
            }
            this.m_thresholdingSession.accept(collectionSet);
        }
        catch (Throwable e) {
            LOG.error("Failed to threshold on {} for {} because of an exception", new Object[]{service, dsName, e});
        }
    }

    private CollectionSet getCollectionSet(MonitoredService service, Map<String, Number> entries, String rrdBaseName, boolean snmpInfoInTags) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("node_label", service.getNodeLabel());
        tags.put("location", service.getNodeLocation());
        tags.put("node_id", Integer.toString(service.getNodeId()));
        LatencyCollectionResource latencyResource = new LatencyCollectionResource(service.getSvcName(), service.getIpAddr(), service.getNodeLocation(), tags);
        if (snmpInfoInTags) {
            latencyResource.addServiceParam("interface-info-in-tags", "true");
        }
        for (Map.Entry<String, Number> entry : entries.entrySet()) {
            String ds = entry.getKey();
            Number value = entry.getValue() != null ? (Number)entry.getValue() : (Number)Double.NaN;
            LatencyCollectionAttributeType latencyType = new LatencyCollectionAttributeType(rrdBaseName, ds);
            latencyResource.addAttribute((CollectionAttribute)new LatencyCollectionAttribute(latencyResource, latencyType, ds, Double.valueOf(value.doubleValue())));
        }
        SingleResourceCollectionSet collectionSet = new SingleResourceCollectionSet((CollectionResource)latencyResource, new Date());
        collectionSet.setStatus(CollectionStatus.SUCCEEDED);
        return collectionSet;
    }
}

