/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Win32ServiceMonitor
extends SnmpMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(Win32ServiceMonitor.class);
    private static final String SV_SVC_OPERATING_STATE_OID = ".1.3.6.1.4.1.77.1.2.3.1.3";
    private static final String DEFAULT_SERVICE_NAME = "Server";

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        String serviceName = ParameterMap.getKeyedString(parameters, (String)"service-name", (String)DEFAULT_SERVICE_NAME);
        int snLength = serviceName.length();
        StringBuilder serviceOidBuf = new StringBuilder(SV_SVC_OPERATING_STATE_OID);
        serviceOidBuf.append(".").append(Integer.toString(snLength));
        for (byte thisByte : serviceName.getBytes()) {
            serviceOidBuf.append(".").append(Byte.toString(thisByte));
        }
        LOG.debug("For Win32 service '{}', OID to check is {}", (Object)serviceName, (Object)serviceOidBuf);
        parameters.put("oid", serviceOidBuf.toString());
        parameters.put("operator", "=");
        parameters.put("operand", "1");
        return super.poll(svc, parameters);
    }
}

