/*
 * Decompiled with CFR 0.152.
 */
package geo.google.mapping;

import geo.google.GeoException;
import geo.google.datamodel.GeoAltitude;
import geo.google.datamodel.GeoCoordinate;
import geo.google.datamodel.GeoStatusCode;

public class MappingUtils {
    private MappingUtils() {
    }

    public static GeoCoordinate stringToCoordinate(String coord) throws GeoException {
        if (coord == null) {
            return new GeoCoordinate();
        }
        String[] items = coord.split(",");
        if (items.length == 3) {
            GeoCoordinate ret = new GeoCoordinate(Double.parseDouble(items[0]), Double.parseDouble(items[1]), new GeoAltitude(Double.parseDouble(items[2])));
            return ret;
        }
        if (items.length == 4) {
            int code = Integer.parseInt(items[0]);
            GeoStatusCode status = GeoStatusCode.getStatusCode(code);
            if (status != GeoStatusCode.G_GEO_SUCCESS) {
                throw new GeoException("Error Status Code: " + status.getCodeName(), status);
            }
            return new GeoCoordinate(Double.parseDouble(items[3]), Double.parseDouble(items[2]), new GeoAltitude());
        }
        throw new GeoException("Standardizer received unknown value: " + coord);
    }
}

