/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.PropertiesCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RrdMetaDataUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RrdMetaDataUtils.class);
    private static PropertiesCache s_cache = new PropertiesCache();

    public static void createMetaDataFile(String directory, String rrdName, Map<String, String> attributeMappings) {
        File metaFile = new File(directory + File.separator + rrdName + ".meta");
        LOG.info("createMetaDataFile: creating meta data file {} with values '{}'", (Object)metaFile, attributeMappings);
        try {
            if (metaFile.exists()) {
                s_cache.updateProperties(metaFile, attributeMappings);
            } else {
                s_cache.saveProperties(metaFile, attributeMappings);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to save metadata file {}", (Object)metaFile, (Object)e);
        }
    }

    public static Map<String, String> readMetaDataFile(File directory, String rrdName) {
        File metaFile = new File(String.valueOf(directory) + File.separator + rrdName + ".meta");
        try {
            Properties props = s_cache.getProperties(metaFile);
            HashMap<String, String> ret = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                Object value = entry.getValue();
                ret.put(entry.getKey().toString(), value == null ? null : value.toString());
            }
            return ret;
        }
        catch (IOException e) {
            LOG.warn("Failed to retrieve metadata from {}", (Object)metaFile, (Object)e);
            return Collections.emptyMap();
        }
    }
}

