/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;

public enum UrlDirection {
    src(1),
    dst(2);

    public final int value;

    private UrlDirection(int value) {
        this.value = value;
    }

    public static UrlDirection from(ByteBuf buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuf)buffer);
        switch (value) {
            case 1: {
                return src;
            }
            case 2: {
                return dst;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeInt32(this.value);
    }
}

