/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.CounterData;

public class NvidiaGpu
implements CounterData {
    public final long device_count;
    public final long processes;
    public final long gpu_time;
    public final long mem_time;
    public final UnsignedLong mem_total;
    public final UnsignedLong mem_free;
    public final long ecc_errors;
    public final long energy;
    public final long temperature;
    public final long fan_speed;

    public NvidiaGpu(ByteBuf buffer) throws InvalidPacketException {
        this.device_count = BufferUtils.uint32((ByteBuf)buffer);
        this.processes = BufferUtils.uint32((ByteBuf)buffer);
        this.gpu_time = BufferUtils.uint32((ByteBuf)buffer);
        this.mem_time = BufferUtils.uint32((ByteBuf)buffer);
        this.mem_total = BufferUtils.uint64((ByteBuf)buffer);
        this.mem_free = BufferUtils.uint64((ByteBuf)buffer);
        this.ecc_errors = BufferUtils.uint32((ByteBuf)buffer);
        this.energy = BufferUtils.uint32((ByteBuf)buffer);
        this.temperature = BufferUtils.uint32((ByteBuf)buffer);
        this.fan_speed = BufferUtils.uint32((ByteBuf)buffer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("device_count", this.device_count).add("processes", this.processes).add("gpu_time", this.gpu_time).add("mem_time", this.mem_time).add("mem_total", (Object)this.mem_total).add("mem_free", (Object)this.mem_free).add("ecc_errors", this.ecc_errors).add("energy", this.energy).add("temperature", this.temperature).add("fan_speed", this.fan_speed).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("device_count", this.device_count);
        bsonWriter.writeInt64("processes", this.processes);
        bsonWriter.writeInt64("gpu_time", this.gpu_time);
        bsonWriter.writeInt64("mem_time", this.mem_time);
        bsonWriter.writeInt64("mem_total", this.mem_total.longValue());
        bsonWriter.writeInt64("mem_free", this.mem_free.longValue());
        bsonWriter.writeInt64("ecc_errors", this.ecc_errors);
        bsonWriter.writeInt64("energy", this.energy);
        bsonWriter.writeInt64("temperature", this.temperature);
        bsonWriter.writeInt64("fan_speed", this.fan_speed);
        bsonWriter.writeEndDocument();
    }
}

