/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util.internal;

import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.asteriskjava.util.Log;

public class Log4JLogger
implements Log,
Serializable {
    private static final long serialVersionUID = 3545240215095883829L;
    private static final String FQCN = Log4JLogger.class.getName();
    private static final boolean IS12 = Priority.class.isAssignableFrom(Level.class);
    private transient Logger logger = null;
    private String name = null;

    public Log4JLogger() {
    }

    public Log4JLogger(Class<?> clazz) {
        this.name = clazz.getName();
        this.logger = this.getLogger();
    }

    public void trace(Object message) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        }
    }

    public void trace(Object message, Throwable t) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        }
    }

    @Override
    public void debug(Object message) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.DEBUG, message, t);
        }
    }

    @Override
    public void info(Object message) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, null);
        }
    }

    public void info(Object message, Throwable t) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.INFO, message, t);
        }
    }

    @Override
    public void warn(Object message) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, null);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.WARN, message, t);
        }
    }

    @Override
    public void error(Object message) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, null);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.ERROR, message, t);
        }
    }

    public void fatal(Object message) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, null);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, null);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (IS12) {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, t);
        } else {
            this.getLogger().log(FQCN, (Priority)Level.FATAL, message, t);
        }
    }

    public final Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger((String)this.name);
        }
        return this.logger;
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        if (IS12) {
            return this.getLogger().isEnabledFor((Priority)Level.ERROR);
        }
        return this.getLogger().isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isFatalEnabled() {
        if (IS12) {
            return this.getLogger().isEnabledFor((Priority)Level.FATAL);
        }
        return this.getLogger().isEnabledFor((Priority)Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        if (IS12) {
            return this.getLogger().isEnabledFor((Priority)Level.WARN);
        }
        return this.getLogger().isEnabledFor((Priority)Level.WARN);
    }
}

