/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi.command;

import org.asteriskjava.fastagi.command.AbstractAgiCommand;

public class GetDataCommand
extends AbstractAgiCommand {
    private static final long serialVersionUID = 3978141041352128820L;
    private static final int DEFAULT_MAX_DIGITS = 1024;
    private static final int DEFAULT_TIMEOUT = 0;
    private String file;
    private long timeout;
    private int maxDigits;

    public GetDataCommand(String file) {
        this.file = file;
        this.timeout = 0L;
        this.maxDigits = 1024;
    }

    public GetDataCommand(String file, long timeout) {
        this.file = file;
        this.timeout = timeout;
        this.maxDigits = 1024;
    }

    public GetDataCommand(String file, long timeout, int maxDigits) throws IllegalArgumentException {
        if (maxDigits < 1 || maxDigits > 1024) {
            throw new IllegalArgumentException("maxDigits must be in [1..1024]");
        }
        this.file = file;
        this.timeout = timeout;
        this.maxDigits = maxDigits;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxDigits() {
        return this.maxDigits;
    }

    public void setMaxDigits(int maxDigits) throws IllegalArgumentException {
        if (maxDigits < 1 || maxDigits > 1024) {
            throw new IllegalArgumentException("maxDigits must be in [1..1024]");
        }
        this.maxDigits = maxDigits;
    }

    @Override
    public String buildCommand() {
        if (this.maxDigits == 1024) {
            if (this.timeout == 0L) {
                return "GET DATA " + this.escapeAndQuote(this.file);
            }
            return "GET DATA " + this.escapeAndQuote(this.file) + " " + this.timeout;
        }
        return "GET DATA " + this.escapeAndQuote(this.file) + " " + this.timeout + " " + this.maxDigits;
    }
}

