/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.dao.jaxb;

import java.io.File;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlDataCollectionConfig;
import org.opennms.protocols.xml.config.XmlGroups;
import org.opennms.protocols.xml.config.XmlSource;
import org.opennms.protocols.xml.dao.XmlDataCollectionConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class XmlDataCollectionConfigDaoJaxb
extends AbstractJaxbConfigDao<XmlDataCollectionConfig, XmlDataCollectionConfig>
implements XmlDataCollectionConfigDao {
    private static final Logger LOG = LoggerFactory.getLogger(XmlDataCollectionConfigDaoJaxb.class);

    public XmlDataCollectionConfigDaoJaxb() {
        super(XmlDataCollectionConfig.class, "XML Data Collection Configuration");
    }

    @Override
    public XmlDataCollection getDataCollectionByName(String name) {
        XmlDataCollectionConfig config = (XmlDataCollectionConfig)this.getContainer().getObject();
        for (XmlDataCollection dataCol : config.getXmlDataCollections()) {
            if (!dataCol.getName().equals(name)) continue;
            return dataCol;
        }
        return null;
    }

    @Override
    public XmlDataCollection getDataCollectionByIndex(int idx) {
        XmlDataCollectionConfig config = (XmlDataCollectionConfig)this.getContainer().getObject();
        return config.getXmlDataCollections().get(idx);
    }

    @Override
    public XmlDataCollectionConfig getConfig() {
        return (XmlDataCollectionConfig)this.getContainer().getObject();
    }

    protected XmlDataCollectionConfig translateConfig(XmlDataCollectionConfig config) {
        for (XmlDataCollection collection : config.getXmlDataCollections()) {
            for (XmlSource source : collection.getXmlSources()) {
                this.parseXmlGroups(source);
            }
        }
        return config;
    }

    private void parseXmlGroups(XmlSource source) {
        if (!source.hasImportGroups()) {
            return;
        }
        for (String importGroup : source.getImportGroupsList()) {
            File file = new File(ConfigFileConstants.getHome(), "/etc/" + importGroup);
            LOG.debug("parseXmlGroups: parsing {}", (Object)file);
            XmlGroups groups = (XmlGroups)JaxbUtils.unmarshal(XmlGroups.class, (Resource)new FileSystemResource(file));
            source.getXmlGroups().addAll(groups.getXmlGroups());
        }
    }
}

