/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.common.collectors;

import java.net.InetAddress;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.opennms.features.apilayer.common.collectors.CollectionSetMapper;
import org.opennms.integration.api.v1.collectors.CollectionRequest;
import org.opennms.integration.api.v1.collectors.CollectionSet;
import org.opennms.integration.api.v1.collectors.ServiceCollectorFactory;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInitializationException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCollectorImpl<T extends org.opennms.integration.api.v1.collectors.ServiceCollector>
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCollectorImpl.class);
    private final ServiceCollectorFactory<T> serviceCollectorFactory;
    private final RrdRepository rrdRepo;

    public ServiceCollectorImpl(ServiceCollectorFactory<T> serviceCollectorFactory, RrdRepository rrdRepo) {
        this.serviceCollectorFactory = serviceCollectorFactory;
        this.rrdRepo = rrdRepo;
    }

    public void initialize() throws CollectionInitializationException {
    }

    public void validateAgent(CollectionAgent agent, Map<String, Object> parameters) {
    }

    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) throws CollectionException {
        org.opennms.integration.api.v1.collectors.ServiceCollector serviceCollector = this.serviceCollectorFactory.createCollector();
        serviceCollector.initialize();
        try {
            CollectionRequestImpl collectionRequest = new CollectionRequestImpl(agent);
            CompletableFuture future = serviceCollector.collect((CollectionRequest)collectionRequest, parameters);
            CollectionSetBuilder builder = new CollectionSetBuilder(agent);
            org.opennms.integration.api.v1.collectors.CollectionSet collectionSet = (org.opennms.integration.api.v1.collectors.CollectionSet)future.get();
            if (collectionSet.getStatus().equals((Object)CollectionSet.Status.FAILED)) {
                return builder.withTimestamp(new Date(collectionSet.getTimeStamp())).withStatus(CollectionStatus.FAILED).build();
            }
            return CollectionSetMapper.buildCollectionSet(builder, collectionSet);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Collection failed", (Throwable)e);
            throw new CollectionException("Collection failed", (Throwable)e);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return this.rrdRepo;
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        return this.serviceCollectorFactory.getRuntimeAttributes((CollectionRequest)new CollectionRequestImpl(agent), parameters);
    }

    public String getEffectiveLocation(String location) {
        return null;
    }

    public Map<String, String> marshalParameters(Map<String, Object> parameters) {
        return this.serviceCollectorFactory.marshalParameters(parameters);
    }

    public Map<String, Object> unmarshalParameters(Map<String, String> parameters) {
        return this.serviceCollectorFactory.unmarshalParameters(parameters);
    }

    private class CollectionRequestImpl
    implements CollectionRequest {
        private CollectionAgent collectionAgent;

        public CollectionRequestImpl(CollectionAgent collectionAgent) {
            this.collectionAgent = collectionAgent;
        }

        public InetAddress getAddress() {
            return this.collectionAgent.getAddress();
        }

        public int getNodeId() {
            return this.collectionAgent.getNodeId();
        }
    }
}

