/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client.template;

import java.util.Objects;

public class Version {
    private int major;
    private int minor;
    private int patch;

    public Version(int major, int minor, int patch) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Versions must be non-negative.");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version fromVersionString(String versionString) {
        String[] tokens = versionString.split("\\.");
        if (tokens.length != 3) {
            throw new IllegalArgumentException("Invalid version string: " + versionString);
        }
        return new Version(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]));
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return Objects.equals(this.major, version.major) && Objects.equals(this.minor, version.minor) && Objects.equals(this.patch, version.patch);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }
}

