/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto;

import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.Record;
import org.opennms.netmgt.telemetry.protocols.bmp.adapter.openbmp.proto.Type;

public class Message {
    private final String collectorHashId;
    private final Type type;
    private final List<Record> records;

    public Message(String collectorHashId, Type type, List<Record> records) {
        this.collectorHashId = Objects.requireNonNull(collectorHashId);
        this.type = Objects.requireNonNull(type);
        this.records = Objects.requireNonNull(records);
        for (Record record : records) {
            assert (record.getType() == type);
        }
    }

    private static void serializeHeader(StringBuffer buffer, String key, String value) {
        buffer.append(key).append(": ").append(value).append('\n');
    }

    public final void serialize(StringBuffer buffer) {
        StringBuffer data = new StringBuffer();
        for (Record record : this.records) {
            record.serialize(data);
        }
        Message.serializeHeader(buffer, "V", "1.7");
        Message.serializeHeader(buffer, "C_HASH_ID", this.collectorHashId);
        Message.serializeHeader(buffer, "T", this.type.toString());
        Message.serializeHeader(buffer, "L", Integer.toString(data.length()));
        Message.serializeHeader(buffer, "R", Integer.toString(this.records.size()));
        buffer.append('\n');
        buffer.append(data);
    }

    public String getCollectorHashId() {
        return this.collectorHashId;
    }

    public Type getType() {
        return this.type;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public int count() {
        return this.records.size();
    }
}

