/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

public abstract class TimeSeries {
    public static final String TIMESERIES_GRAPHS_ENGINE_PROPERTY = "org.opennms.web.graphs.engine";
    public static final String TIMESERIES_STRATEGY_PROPERTY = "org.opennms.timeseries.strategy";
    public static final String DEFAULT_GRAPHS_ENGINE_TYPE = "backshift";
    public static final String RRD_STRATEGY_CLASS_PROPERTY = "org.opennms.rrd.strategyClass";
    public static final String RRD_TIME_SERIES_STRATEGY_NAME = "rrd";
    public static final String DEFAULT_RRD_STRATEGY_CLASS = "org.opennms.netmgt.rrd.rrdtool.MultithreadedJniRrdStrategy";
    private static final String NEWTS_TIME_SERIES_STRATEGY_NAME = "newts";
    private static final String EVALUATE_TIME_SERIES_STRATEGY_NAME = "evaluate";
    private static final String TCP_TIME_SERIES_STRATEGY_NAME = "tcp";
    private static final String INTEGRATION_LAYER_TIME_SERIES_STRATEGY_NAME = "integration";

    protected TimeSeries() {
        throw new UnsupportedOperationException();
    }

    public static Strategy getTimeseriesStrategy() {
        String effectiveStrategyName = System.getProperty(TIMESERIES_STRATEGY_PROPERTY, RRD_TIME_SERIES_STRATEGY_NAME);
        for (Strategy strategy : Strategy.values()) {
            if (!strategy.getName().equalsIgnoreCase(effectiveStrategyName)) continue;
            return strategy;
        }
        throw new IllegalArgumentException("Unsupported time series strategy: " + effectiveStrategyName);
    }

    public static String getGraphEngine() {
        String graphEngine = System.getProperty(TIMESERIES_GRAPHS_ENGINE_PROPERTY, DEFAULT_GRAPHS_ENGINE_TYPE);
        if ("auto".equals(graphEngine)) {
            return DEFAULT_GRAPHS_ENGINE_TYPE;
        }
        return graphEngine;
    }

    public static enum Strategy {
        RRD("rrd", "RRD implementation"),
        NEWTS("newts", "Newts"),
        EVALUATE("evaluate", "Evaluate (Sizing mode, all data discarded)"),
        TCP("tcp", "TCP (protobuf)"),
        INTEGRATION("integration", "Integration (the timeseries integration layer, to be used for TimeseriesStorage implementations)");

        private final String m_name;
        private final String m_descr;

        private Strategy(String name, String descr) {
            this.m_name = name;
            this.m_descr = descr;
        }

        private Strategy(String name) {
            this(name, name);
        }

        public String getName() {
            return this.m_name;
        }

        public String getDescr() {
            return this.m_descr;
        }
    }
}

