/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.features.topology.api.support.hops.VertexHopCriteria;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.RefComparator;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.topo.linkd.internal.LinkdTopologyFactory;

public class LinkdHopCriteria
extends VertexHopCriteria {
    private final String m_nodeId;
    private final LinkdTopologyFactory m_linkdTopologyFactory;

    public static synchronized VertexHopCriteria createCriteria(String nodeId, String nodeLabel, LinkdTopologyFactory linkdTopologyFactory) {
        return new LinkdHopCriteria(nodeId, nodeLabel, linkdTopologyFactory);
    }

    private LinkdHopCriteria(String nodeId, String nodeLabel, LinkdTopologyFactory linkdTopologyFactory) {
        super(nodeId, nodeLabel);
        this.m_nodeId = nodeId;
        this.m_linkdTopologyFactory = linkdTopologyFactory;
    }

    public String getNamespace() {
        return this.m_linkdTopologyFactory.getActiveNamespace();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_nodeId == null ? 0 : this.m_nodeId.hashCode());
        result = 31 * result + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LinkdHopCriteria) {
            LinkdHopCriteria ref = (LinkdHopCriteria)((Object)obj);
            return ref.m_nodeId.equals(this.m_nodeId) && ref.getNamespace().equals(this.getNamespace());
        }
        return false;
    }

    public Set<VertexRef> getVertices() {
        TreeSet<VertexRef> vertices = new TreeSet<VertexRef>((Comparator<VertexRef>)new RefComparator());
        vertices.add((VertexRef)new DefaultVertexRef(this.getNamespace(), this.m_nodeId, this.getLabel()));
        return vertices;
    }
}

