/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.limit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.core.Registry;
import org.extremecomponents.table.limit.Filter;
import org.extremecomponents.table.limit.FilterSet;
import org.extremecomponents.table.limit.LimitFactory;
import org.extremecomponents.table.limit.Sort;

public abstract class AbstractLimitFactory
implements LimitFactory {
    protected String tableId;
    protected String prefixWithTableId;
    protected boolean isExported;
    protected Registry registry;
    protected Context context;

    @Override
    public boolean isExported() {
        return this.isExported;
    }

    boolean getExported() {
        String exportTableId = this.context.getParameter("ec_eti");
        if (StringUtils.isBlank((CharSequence)exportTableId)) {
            return false;
        }
        return exportTableId.equals(this.tableId);
    }

    @Override
    public int getCurrentRowsDisplayed(int totalRows, int rowsDisplayed) {
        if (this.isExported || !this.showPagination()) {
            return totalRows;
        }
        String currentRowsDisplayed = this.registry.getParameter(this.prefixWithTableId + "crd");
        if (StringUtils.isNotBlank((CharSequence)currentRowsDisplayed)) {
            return Integer.parseInt(currentRowsDisplayed);
        }
        return rowsDisplayed;
    }

    @Override
    public int getPage() {
        if (this.isExported) {
            return 1;
        }
        String page = this.registry.getParameter(this.prefixWithTableId + "p");
        if (!StringUtils.isEmpty((CharSequence)page)) {
            return Integer.parseInt(page);
        }
        return 1;
    }

    @Override
    public Sort getSort() {
        String propertyOrAlias;
        String value;
        Map<String, String> sortedParameters = this.getSortedOrFilteredParameters("s_");
        if (sortedParameters == null) {
            return new Sort();
        }
        Iterator<String> iter = sortedParameters.keySet().iterator();
        if (iter.hasNext() && !(value = sortedParameters.get(propertyOrAlias = iter.next())).equals("default")) {
            String property = this.getProperty(propertyOrAlias);
            return new Sort(propertyOrAlias, property, value);
        }
        return new Sort();
    }

    @Override
    public FilterSet getFilterSet() {
        Map<String, String> filteredParameters = this.getSortedOrFilteredParameters("f_");
        FilterSet filterSet = this.getFilterSet(filteredParameters);
        if (filterSet.isCleared()) {
            this.removeFilterParameters();
            filterSet = new FilterSet(filterSet.getAction(), new Filter[0]);
        }
        return filterSet;
    }

    void removeFilterParameters() {
        Set<String> set = this.registry.getParameterMap().keySet();
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (!name.startsWith(this.prefixWithTableId + "f_")) continue;
            iter.remove();
        }
    }

    FilterSet getFilterSet(Map<String, String> filteredParameters) {
        if (filteredParameters == null) {
            return new FilterSet();
        }
        String action = filteredParameters.get("a");
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (String propertyOrAlias : filteredParameters.keySet()) {
            String value = filteredParameters.get(propertyOrAlias);
            if (StringUtils.isBlank((CharSequence)value) || propertyOrAlias.equals("a")) continue;
            String property = this.getProperty(propertyOrAlias);
            filters.add(new Filter(propertyOrAlias, property, value));
        }
        return new FilterSet(action, filters.toArray(new Filter[filters.size()]));
    }

    @Override
    public Map<String, String> getSortedOrFilteredParameters(String parameter) {
        HashMap<String, String> subset = new HashMap<String, String>();
        String find = this.prefixWithTableId + parameter;
        Set<String> set = this.registry.getParameterMap().keySet();
        for (String key : set) {
            String value;
            if (!key.startsWith(find) || !StringUtils.isNotBlank((CharSequence)(value = this.registry.getParameter(key)))) continue;
            String propertyOrAlias = StringUtils.substringAfter((String)key, (String)find);
            subset.put(propertyOrAlias, value);
        }
        return subset;
    }

    private String getProperty(String propertyOrAlias) {
        String property = this.registry.getParameter(this.prefixWithTableId + "a_" + propertyOrAlias);
        if (StringUtils.isNotBlank((CharSequence)property)) {
            return property;
        }
        return propertyOrAlias;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("tableId", (Object)this.tableId);
        return builder.toString();
    }

    protected abstract boolean showPagination();
}

