/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.opennms.netmgt.dao.api.GraphDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.api.Util;
import org.opennms.web.svclayer.api.ResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultResourceService
implements ResourceService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResourceService.class);
    private ResourceDao m_resourceDao;
    private GraphDao m_graphDao;
    private EventProxy m_eventProxy;

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public GraphDao getGraphDao() {
        return this.m_graphDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"resourceDao property is not set");
        Assert.state((this.m_graphDao != null ? 1 : 0) != 0, (String)"graphDao property is not set");
        Assert.state((this.m_eventProxy != null ? 1 : 0) != 0, (String)"eventProxy property is not set");
    }

    @Override
    public List<OnmsResource> findTopLevelResources() {
        return this.m_resourceDao.findTopLevelResources();
    }

    @Override
    public List<OnmsResource> findNodeChildResources(OnmsNode node) {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        if (node != null) {
            if (ResourceTypeUtils.isStoreByForeignSource() && node.getForeignSource() != null) {
                String source = node.getForeignSource() + ":" + node.getForeignId();
                resources.addAll(this.findNodeSourceChildResources(source));
            } else {
                resources.addAll(this.findNodeChildResources(node.getId()));
            }
        }
        return resources;
    }

    @Override
    public List<OnmsResource> findNodeChildResources(int nodeId) {
        List<Object> resources = new ArrayList<OnmsResource>();
        OnmsResource resource = this.m_resourceDao.getResourceById(ResourceId.get((String)"node", (String)Integer.toString(nodeId)));
        if (resource != null) {
            resources = resource.getChildResources();
            resources.size();
        }
        return resources;
    }

    @Override
    public List<OnmsResource> findDomainChildResources(String domain) {
        List<Object> resources = new ArrayList<OnmsResource>();
        OnmsResource resource = this.m_resourceDao.getResourceById(ResourceId.get((String)"domain", (String)domain));
        if (resource != null) {
            resources = resource.getChildResources();
            resources.size();
        }
        return resources;
    }

    @Override
    public List<OnmsResource> findNodeSourceChildResources(String nodeSource) {
        List<Object> resources = new ArrayList<OnmsResource>();
        OnmsResource resource = this.m_resourceDao.getResourceById(ResourceId.get((String)"nodeSource", (String)nodeSource));
        if (resource != null) {
            resources = resource.getChildResources();
            resources.size();
        }
        return resources;
    }

    @Override
    public List<OnmsResource> findChildResources(OnmsResource resource, String ... resourceTypeMatches) {
        LinkedList<OnmsResource> matchingChildResources = new LinkedList<OnmsResource>();
        if (resource != null) {
            for (OnmsResource childResource : resource.getChildResources()) {
                boolean addGraph = false;
                if (resourceTypeMatches.length > 0) {
                    for (String resourceTypeMatch : resourceTypeMatches) {
                        if (!resourceTypeMatch.equals(childResource.getResourceType().getName())) continue;
                        addGraph = true;
                        break;
                    }
                } else {
                    addGraph = true;
                }
                if (!addGraph) continue;
                matchingChildResources.add(DefaultResourceService.checkLabelForQuotes(childResource));
            }
        }
        return matchingChildResources;
    }

    private static OnmsResource checkLabelForQuotes(OnmsResource childResource) {
        String lbl = Util.convertToJsSafeString(childResource.getLabel());
        OnmsResource resource = new OnmsResource(childResource.getName(), lbl, childResource.getResourceType(), childResource.getAttributes(), childResource.getPath());
        resource.setParent(childResource.getParent());
        resource.setEntity(childResource.getEntity());
        resource.setLink(childResource.getLink());
        return resource;
    }

    @Override
    public OnmsResource getResourceById(ResourceId id) {
        return this.m_resourceDao.getResourceById(id);
    }

    @Override
    public PrefabGraph[] findPrefabGraphsForResource(OnmsResource resource) {
        return this.m_graphDao.getPrefabGraphsForResource(resource);
    }

    @Override
    public void promoteGraphAttributesForResource(OnmsResource resource) {
        String rrdBaseDir = System.getProperty("rrd.base.dir");
        LinkedList<CallSite> rrdFiles = new LinkedList<CallSite>();
        for (RrdGraphAttribute attribute : resource.getRrdGraphAttributes().values()) {
            rrdFiles.add((CallSite)((Object)(rrdBaseDir + File.separator + attribute.getRrdRelativePath())));
        }
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/promoteQueueData", "OpenNMS.Webapp");
        bldr.addParam("filesToPromote", rrdFiles);
        try {
            this.m_eventProxy.send(bldr.getEvent());
        }
        catch (EventProxyException e) {
            LOG.warn("Unable to send file promotion event to opennms: {}", (Object)e, (Object)e);
        }
    }

    @Override
    public void promoteGraphAttributesForResource(ResourceId resourceId) {
        this.promoteGraphAttributesForResource(this.getResourceById(resourceId));
    }

    @Override
    public PrefabGraph[] findPrefabGraphsForChildResources(OnmsResource resource, String ... resourceTypeMatches) {
        LinkedHashMap<String, PrefabGraph> childGraphs = new LinkedHashMap<String, PrefabGraph>();
        for (OnmsResource r : this.findChildResources(resource, resourceTypeMatches)) {
            for (PrefabGraph g : this.findPrefabGraphsForResource(r)) {
                childGraphs.put(g.getName(), g);
            }
        }
        return childGraphs.values().toArray(new PrefabGraph[childGraphs.size()]);
    }

    @Override
    public PrefabGraph getPrefabGraph(String name) {
        return this.m_graphDao.getPrefabGraph(name);
    }
}

