/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.transport.Disposition;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.amqp.transport.Role;
import org.apache.qpid.proton.amqp.transport.Transfer;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportDelivery;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportLink;
import org.apache.qpid.proton.engine.impl.TransportReceiver;

class TransportSession {
    private static final int HANDLE_MAX = 65535;
    private static final UnsignedInteger DEFAULT_WINDOW_SIZE = UnsignedInteger.valueOf(Integer.MAX_VALUE);
    private final TransportImpl _transport;
    private final SessionImpl _session;
    private int _localChannel = -1;
    private int _remoteChannel = -1;
    private boolean _openSent;
    private final UnsignedInteger _handleMax = UnsignedInteger.valueOf(65535);
    private UnsignedInteger _outgoingDeliveryId = UnsignedInteger.ZERO;
    private UnsignedInteger _incomingWindowSize = UnsignedInteger.ZERO;
    private UnsignedInteger _outgoingWindowSize = UnsignedInteger.ZERO;
    private UnsignedInteger _nextOutgoingId = UnsignedInteger.ONE;
    private UnsignedInteger _nextIncomingId = null;
    private final Map<UnsignedInteger, TransportLink<?>> _remoteHandlesMap = new HashMap();
    private final Map<UnsignedInteger, TransportLink<?>> _localHandlesMap = new HashMap();
    private final Map<String, TransportLink> _halfOpenSenderLinks = new HashMap<String, TransportLink>();
    private final Map<String, TransportLink> _halfOpenReceiverLinks = new HashMap<String, TransportLink>();
    private UnsignedInteger _incomingDeliveryId = null;
    private UnsignedInteger _remoteIncomingWindow;
    private UnsignedInteger _remoteOutgoingWindow;
    private UnsignedInteger _remoteNextIncomingId = this._nextOutgoingId;
    private UnsignedInteger _remoteNextOutgoingId;
    private final Map<UnsignedInteger, DeliveryImpl> _unsettledIncomingDeliveriesById = new HashMap<UnsignedInteger, DeliveryImpl>();
    private final Map<UnsignedInteger, DeliveryImpl> _unsettledOutgoingDeliveriesById = new HashMap<UnsignedInteger, DeliveryImpl>();
    private int _unsettledIncomingSize;
    private boolean _endReceived;
    private boolean _beginSent;

    TransportSession(TransportImpl transport, SessionImpl session) {
        this._transport = transport;
        this._session = session;
        this._outgoingWindowSize = UnsignedInteger.valueOf(session.getOutgoingWindow());
    }

    void unbind() {
        this.unsetLocalChannel();
        this.unsetRemoteChannel();
    }

    public SessionImpl getSession() {
        return this._session;
    }

    public int getLocalChannel() {
        return this._localChannel;
    }

    public void setLocalChannel(int localChannel) {
        if (!this.isLocalChannelSet()) {
            this._session.incref();
        }
        this._localChannel = localChannel;
    }

    public int getRemoteChannel() {
        return this._remoteChannel;
    }

    public void setRemoteChannel(int remoteChannel) {
        if (!this.isRemoteChannelSet()) {
            this._session.incref();
        }
        this._remoteChannel = remoteChannel;
    }

    public boolean isOpenSent() {
        return this._openSent;
    }

    public void setOpenSent(boolean openSent) {
        this._openSent = openSent;
    }

    public boolean isRemoteChannelSet() {
        return this._remoteChannel != -1;
    }

    public boolean isLocalChannelSet() {
        return this._localChannel != -1;
    }

    public void unsetLocalChannel() {
        if (this.isLocalChannelSet()) {
            this.unsetLocalHandles();
            this._session.decref();
        }
        this._localChannel = -1;
    }

    private void unsetLocalHandles() {
        for (TransportLink<?> tl : this._localHandlesMap.values()) {
            tl.clearLocalHandle();
        }
        this._localHandlesMap.clear();
    }

    public void unsetRemoteChannel() {
        if (this.isRemoteChannelSet()) {
            this.unsetRemoteHandles();
            this._session.decref();
        }
        this._remoteChannel = -1;
    }

    private void unsetRemoteHandles() {
        for (TransportLink<?> tl : this._remoteHandlesMap.values()) {
            tl.clearRemoteHandle();
        }
        this._remoteHandlesMap.clear();
    }

    public UnsignedInteger getHandleMax() {
        return this._handleMax;
    }

    public UnsignedInteger getIncomingWindowSize() {
        return this._incomingWindowSize;
    }

    void updateIncomingWindow() {
        int incomingCapacity = this._session.getIncomingCapacity();
        int size2 = this._transport.getMaxFrameSize();
        this._incomingWindowSize = incomingCapacity <= 0 || size2 <= 0 ? DEFAULT_WINDOW_SIZE : UnsignedInteger.valueOf((incomingCapacity - this._session.getIncomingBytes()) / size2);
    }

    public UnsignedInteger getOutgoingDeliveryId() {
        return this._outgoingDeliveryId;
    }

    void incrementOutgoingDeliveryId() {
        this._outgoingDeliveryId = this._outgoingDeliveryId.add(UnsignedInteger.ONE);
    }

    public UnsignedInteger getOutgoingWindowSize() {
        return this._outgoingWindowSize;
    }

    public UnsignedInteger getNextOutgoingId() {
        return this._nextOutgoingId;
    }

    public TransportLink getLinkFromRemoteHandle(UnsignedInteger handle) {
        return this._remoteHandlesMap.get(handle);
    }

    public UnsignedInteger allocateLocalHandle(TransportLink transportLink) {
        for (int i = 0; i <= 65535; ++i) {
            UnsignedInteger handle = UnsignedInteger.valueOf(i);
            if (this._localHandlesMap.containsKey(handle)) continue;
            this._localHandlesMap.put(handle, transportLink);
            transportLink.setLocalHandle(handle);
            return handle;
        }
        throw new IllegalStateException("no local handle available for allocation");
    }

    public void addLinkRemoteHandle(TransportLink link2, UnsignedInteger remoteHandle) {
        this._remoteHandlesMap.put(remoteHandle, link2);
    }

    public void addLinkLocalHandle(TransportLink link2, UnsignedInteger localhandle) {
        this._localHandlesMap.put(localhandle, link2);
    }

    public void freeLocalHandle(UnsignedInteger handle) {
        this._localHandlesMap.remove(handle);
    }

    public void freeRemoteHandle(UnsignedInteger handle) {
        this._remoteHandlesMap.remove(handle);
    }

    public TransportLink resolveHalfOpenLink(String name, boolean isSender) {
        if (isSender) {
            return this._halfOpenSenderLinks.remove(name);
        }
        return this._halfOpenReceiverLinks.remove(name);
    }

    public void addHalfOpenLink(TransportLink link2, boolean isSender) {
        if (isSender) {
            this._halfOpenSenderLinks.put(link2.getName(), link2);
        } else {
            this._halfOpenReceiverLinks.put(link2.getName(), link2);
        }
    }

    public void handleTransfer(Transfer transfer, Binary payload) {
        DeliveryImpl delivery;
        this.incrementNextIncomingId();
        TransportReceiver transportReceiver = (TransportReceiver)this.getLinkFromRemoteHandle(transfer.getHandle());
        UnsignedInteger linkIncomingDeliveryId = transportReceiver.getIncomingDeliveryId();
        UnsignedInteger deliveryId = transfer.getDeliveryId();
        if (linkIncomingDeliveryId != null && (linkIncomingDeliveryId.equals(deliveryId) || deliveryId == null)) {
            delivery = this._unsettledIncomingDeliveriesById.get(linkIncomingDeliveryId);
            delivery.getTransportDelivery().incrementSessionSize();
        } else {
            this.verifyNewDeliveryIdSequence(this._incomingDeliveryId, linkIncomingDeliveryId, deliveryId);
            this._incomingDeliveryId = deliveryId;
            ReceiverImpl receiver = transportReceiver.getReceiver();
            Binary deliveryTag = transfer.getDeliveryTag();
            delivery = receiver.delivery(deliveryTag.getArray(), deliveryTag.getArrayOffset(), deliveryTag.getLength());
            UnsignedInteger messageFormat = transfer.getMessageFormat();
            if (messageFormat != null) {
                delivery.setMessageFormat(messageFormat.intValue());
            }
            TransportDelivery transportDelivery = new TransportDelivery(deliveryId, delivery, transportReceiver);
            delivery.setTransportDelivery(transportDelivery);
            transportReceiver.setIncomingDeliveryId(deliveryId);
            this._unsettledIncomingDeliveriesById.put(deliveryId, delivery);
            this.getSession().incrementIncomingDeliveries(1);
        }
        if (transfer.getState() != null) {
            delivery.setRemoteDeliveryState(transfer.getState());
        }
        ++this._unsettledIncomingSize;
        boolean aborted = transfer.getAborted();
        if (payload != null && !aborted) {
            delivery.append(payload);
            this.getSession().incrementIncomingBytes(payload.getLength());
        }
        delivery.updateWork();
        if (!transfer.getMore() || aborted) {
            transportReceiver.setIncomingDeliveryId(null);
            if (aborted) {
                delivery.setAborted();
            } else {
                delivery.setComplete();
            }
            delivery.getLink().getTransportLink().decrementLinkCredit();
            delivery.getLink().getTransportLink().incrementDeliveryCount();
        }
        if (Boolean.TRUE.equals(transfer.getSettled()) || aborted) {
            delivery.setRemoteSettled(true);
        }
        this._incomingWindowSize = this._incomingWindowSize.subtract(UnsignedInteger.ONE);
        if (this._incomingWindowSize.equals(UnsignedInteger.ZERO)) {
            delivery.getLink().modified(false);
        }
        this.getSession().getConnection().put(Event.Type.DELIVERY, delivery);
    }

    private void verifyNewDeliveryIdSequence(UnsignedInteger previousId, UnsignedInteger linkIncomingId, UnsignedInteger newDeliveryId) {
        if (newDeliveryId == null) {
            throw new IllegalStateException("No delivery-id specified on first Transfer of new delivery");
        }
        if (previousId != null && previousId.intValue() + 1 != newDeliveryId.intValue()) {
            throw new IllegalStateException("Expected delivery-id " + previousId.add(UnsignedInteger.ONE) + ", got " + newDeliveryId);
        }
        if (linkIncomingId != null) {
            throw new IllegalStateException("Illegal multiplex of deliveries on same link with delivery-id " + linkIncomingId + " and " + newDeliveryId);
        }
    }

    public void freeLocalChannel() {
        this.unsetLocalChannel();
    }

    public void freeRemoteChannel() {
        this.unsetRemoteChannel();
    }

    private void setRemoteIncomingWindow(UnsignedInteger incomingWindow) {
        this._remoteIncomingWindow = incomingWindow;
    }

    void decrementRemoteIncomingWindow() {
        this._remoteIncomingWindow = this._remoteIncomingWindow.subtract(UnsignedInteger.ONE);
    }

    private void setRemoteOutgoingWindow(UnsignedInteger outgoingWindow) {
        this._remoteOutgoingWindow = outgoingWindow;
    }

    void handleFlow(Flow flow) {
        UnsignedInteger inext = flow.getNextIncomingId();
        UnsignedInteger iwin = flow.getIncomingWindow();
        if (inext != null) {
            this.setRemoteNextIncomingId(inext);
            this.setRemoteIncomingWindow(inext.add(iwin).subtract(this._nextOutgoingId));
        } else {
            this.setRemoteIncomingWindow(iwin);
        }
        this.setRemoteNextOutgoingId(flow.getNextOutgoingId());
        this.setRemoteOutgoingWindow(flow.getOutgoingWindow());
        if (flow.getHandle() != null) {
            TransportLink transportLink = this.getLinkFromRemoteHandle(flow.getHandle());
            transportLink.handleFlow(flow);
        }
    }

    private void setRemoteNextOutgoingId(UnsignedInteger nextOutgoingId) {
        this._remoteNextOutgoingId = nextOutgoingId;
    }

    private void setRemoteNextIncomingId(UnsignedInteger remoteNextIncomingId) {
        this._remoteNextIncomingId = remoteNextIncomingId;
    }

    void handleDisposition(Disposition disposition) {
        Map<UnsignedInteger, DeliveryImpl> unsettledDeliveries;
        UnsignedInteger id = disposition.getFirst();
        UnsignedInteger last = disposition.getLast() == null ? id : disposition.getLast();
        Map<UnsignedInteger, DeliveryImpl> map2 = unsettledDeliveries = disposition.getRole() == Role.RECEIVER ? this._unsettledOutgoingDeliveriesById : this._unsettledIncomingDeliveriesById;
        while (id.compareTo(last) <= 0) {
            DeliveryImpl delivery = unsettledDeliveries.get(id);
            if (delivery != null) {
                if (disposition.getState() != null) {
                    delivery.setRemoteDeliveryState(disposition.getState());
                }
                if (Boolean.TRUE.equals(disposition.getSettled())) {
                    delivery.setRemoteSettled(true);
                    unsettledDeliveries.remove(id);
                }
                delivery.updateWork();
                this.getSession().getConnection().put(Event.Type.DELIVERY, delivery);
            }
            id = id.add(UnsignedInteger.ONE);
        }
    }

    void addUnsettledOutgoing(UnsignedInteger deliveryId, DeliveryImpl delivery) {
        this._unsettledOutgoingDeliveriesById.put(deliveryId, delivery);
    }

    public boolean hasOutgoingCredit() {
        return this._remoteIncomingWindow == null ? false : this._remoteIncomingWindow.compareTo(UnsignedInteger.ZERO) > 0;
    }

    void incrementOutgoingId() {
        this._nextOutgoingId = this._nextOutgoingId.add(UnsignedInteger.ONE);
    }

    public void settled(TransportDelivery transportDelivery) {
        if (transportDelivery.getTransportLink().getLink() instanceof ReceiverImpl) {
            this._unsettledIncomingDeliveriesById.remove(transportDelivery.getDeliveryId());
            this.getSession().modified(false);
        } else {
            this._unsettledOutgoingDeliveriesById.remove(transportDelivery.getDeliveryId());
            this.getSession().modified(false);
        }
    }

    public UnsignedInteger getNextIncomingId() {
        return this._nextIncomingId;
    }

    public void setNextIncomingId(UnsignedInteger nextIncomingId) {
        this._nextIncomingId = nextIncomingId;
    }

    public void incrementNextIncomingId() {
        this._nextIncomingId = this._nextIncomingId.add(UnsignedInteger.ONE);
    }

    public boolean endReceived() {
        return this._endReceived;
    }

    public void receivedEnd() {
        this._endReceived = true;
    }

    public boolean beginSent() {
        return this._beginSent;
    }

    public void sentBegin() {
        this._beginSent = true;
    }
}

