/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPMatchingRuleSchema
extends LDAPSchemaElement {
    private String syntaxString;
    private String[] attributes;

    public LDAPMatchingRuleSchema() {
        super(LDAPSchema.schemaTypeNames[6]);
    }

    public LDAPMatchingRuleSchema(String[] stringArray, String string, String string2, String[] stringArray2, boolean bl, String string3) {
        super(LDAPSchema.schemaTypeNames[6]);
        this.names = (String[])stringArray.clone();
        this.oid = string;
        this.description = string2;
        this.obsolete = bl;
        this.attributes = (String[])stringArray2.clone();
        this.syntaxString = string3;
        super.setValue(this.formatString());
    }

    public LDAPMatchingRuleSchema(String string, String string2) {
        super(LDAPSchema.schemaTypeNames[6]);
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            this.names = (String[])schemaParser.getNames().clone();
            this.oid = schemaParser.getID();
            this.description = schemaParser.getDescription();
            this.obsolete = schemaParser.getObsolete();
            this.syntaxString = schemaParser.getSyntax();
            if (string2 != null) {
                SchemaParser schemaParser2 = new SchemaParser(string2);
                this.attributes = schemaParser2.getApplies();
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String getSyntaxString() {
        return this.syntaxString;
    }

    protected String formatString() {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(" '" + stringArray[i] + "'");
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((string = this.getSyntaxString()) != null) {
            stringBuffer.append(" SYNTAX ");
            stringBuffer.append(string);
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream bufferedInputStream) throws IOException {
        LDAPMatchingRuleSchema lDAPMatchingRuleSchema = (LDAPMatchingRuleSchema)LDAPMatchingRuleSchema.readDSML(bufferedInputStream);
        this.oid = lDAPMatchingRuleSchema.getID();
        this.names = lDAPMatchingRuleSchema.getNames();
        this.description = lDAPMatchingRuleSchema.getDescription();
        this.obsolete = lDAPMatchingRuleSchema.isObsolete();
        Enumeration enumeration = lDAPMatchingRuleSchema.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = lDAPMatchingRuleSchema.getQualifier(string);
            this.setQualifier(string, stringArray);
        }
        super.setValue(this.formatString());
        this.syntaxString = lDAPMatchingRuleSchema.getSyntaxString();
        this.attributes = lDAPMatchingRuleSchema.getAttributes();
        lDAPMatchingRuleSchema = null;
    }

    protected void writeValue(Writer writer) throws IOException {
        String string = this.formatString();
        writer.write(ValueXMLhandler.newLine(2));
        writer.write("<value>");
        writer.write(string);
        writer.write("</value>");
    }

    protected void writeValue(StringBuffer stringBuffer) {
        String string = this.formatString();
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("<value>");
        stringBuffer.append(string);
        stringBuffer.append("</value>");
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPMatchingRuleSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPMatchingRuleSchema)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPMatchingRuleSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPMatchingRuleSchema)this.valuelist.get(0));
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator iterator = this.valuelist.iterator();
                LDAPMatchingRuleSchema lDAPMatchingRuleSchema = new LDAPMatchingRuleSchema();
                byte[] byArray = (byte[])iterator.next();
                StringBuffer stringBuffer = new StringBuffer(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
                try {
                    SchemaParser schemaParser = new SchemaParser(stringBuffer.toString());
                    lDAPMatchingRuleSchema.names = (String[])schemaParser.getNames().clone();
                    lDAPMatchingRuleSchema.oid = schemaParser.getID();
                    lDAPMatchingRuleSchema.description = schemaParser.getDescription();
                    lDAPMatchingRuleSchema.obsolete = schemaParser.getObsolete();
                    lDAPMatchingRuleSchema.syntaxString = schemaParser.getSyntax();
                    lDAPMatchingRuleSchema.setValue(lDAPMatchingRuleSchema.formatString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
                this.setObject(lDAPMatchingRuleSchema);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }
}

