/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;

public class Bootstrap {
    private final PageContext pageContext;
    private final List<String> headTitles = new ArrayList<String>();
    private final List<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>();
    private String ngApp;
    private String scrollSpy;
    private boolean includeLogoutForm;
    private Set<String> flags = new HashSet<String>();

    private Bootstrap(PageContext pageContext) {
        this.pageContext = Objects.requireNonNull(pageContext);
    }

    private static String eval(PageContext pageContext, String attr, String expr) {
        try {
            return Objects.toString(ExpressionEvaluatorManager.evaluate((String)attr, (String)expr, Object.class, (PageContext)pageContext));
        }
        catch (JspException e) {
            throw new RuntimeException(e);
        }
    }

    public void build(HttpServletRequest request) throws JspException {
        request.setAttribute("__bs_headTitles", this.headTitles);
        request.setAttribute("__bs_ngApp", (Object)this.ngApp);
        request.setAttribute("__bs_scrollSpy", (Object)this.scrollSpy);
        request.setAttribute("__bs_includeLogoutForm", (Object)(this.includeLogoutForm ? "true" : "false"));
        request.setAttribute("__bs_breadcrumbs", this.breadcrumbs);
        request.setAttribute("__bs_flags", this.flags);
    }

    public Bootstrap headTitle(String headTitle) {
        this.headTitles.add(Bootstrap.eval(this.pageContext, "headTitle", Objects.requireNonNull(headTitle)));
        return this;
    }

    private Bootstrap breadcrumb(Breadcrumb entry) {
        this.breadcrumbs.add(Objects.requireNonNull(entry));
        return this;
    }

    public Bootstrap breadcrumb(String title) {
        Breadcrumb breadcrumb = new Breadcrumb(Bootstrap.eval(this.pageContext, "breadcrumb.title", title));
        return this.breadcrumb(breadcrumb);
    }

    public Bootstrap breadcrumb(String title, String link) {
        Breadcrumb breadcrumb = new Breadcrumb(Bootstrap.eval(this.pageContext, "breadcrumb.title", title)).withLink(Bootstrap.eval(this.pageContext, "breadcrumb.link", link));
        return this.breadcrumb(breadcrumb);
    }

    public Bootstrap scrollSpy(String scrollSpy) {
        this.scrollSpy = scrollSpy;
        return this;
    }

    public Bootstrap ngApp(String ngApp) {
        this.ngApp = ngApp;
        return this;
    }

    public Bootstrap includeLogoutForm() {
        this.includeLogoutForm = true;
        return this;
    }

    public Bootstrap flags(String ... flags) {
        this.flags.addAll(Arrays.asList(flags));
        return this;
    }

    public static Bootstrap with(PageContext pageContext) {
        return new Bootstrap(pageContext);
    }

    public static class Breadcrumb {
        public final String title;
        public final String link;

        public Breadcrumb(String title) {
            this(title, null);
        }

        public Breadcrumb(String title, String link) {
            this.title = Objects.requireNonNull(title);
            this.link = link;
        }

        public Breadcrumb withLink(String link) {
            return new Breadcrumb(this.title, link);
        }

        public String getTitle() {
            return this.title;
        }

        public String getLink() {
            return this.link;
        }
    }
}

