/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage.filter;

import java.util.Objects;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.filter.NotEqualsFilterNullAware;
import org.opennms.web.filter.SQLType;

public class NegativePerspectiveLocationFilter
extends NotEqualsFilterNullAware {
    public static final String TYPE = "notperspective";

    public NegativePerspectiveLocationFilter(String perspective) {
        super(TYPE, SQLType.STRING, "PERSPECTIVE", "perspective.locationName", perspective);
    }

    @Override
    public String getTextDescription() {
        if (this.getValue() != null) {
            return String.format("polling perspective is not %s", this.getValue());
        }
        return "from non-perspective polling";
    }

    @Override
    public String getTextDescriptionAsSanitizedHtml() {
        if (this.getValue() != null) {
            return String.format("polling perspective is not %s", WebSecurityUtils.sanitizeString((String)((String)this.getValue())));
        }
        return "from perspective polling";
    }

    @Override
    public String toString() {
        return "<NegativePerspectiveLocationFilter: " + this.getDescription() + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NegativePerspectiveLocationFilter that = (NegativePerspectiveLocationFilter)o;
        return Objects.equals(this.getValue(), that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }
}

