/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletContext;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.event.filter.AcknowledgedByFilter;
import org.opennms.web.event.filter.AfterDateFilter;
import org.opennms.web.event.filter.AlarmIDFilter;
import org.opennms.web.event.filter.BeforeDateFilter;
import org.opennms.web.event.filter.EventIdFilter;
import org.opennms.web.event.filter.EventTextFilter;
import org.opennms.web.event.filter.ExactUEIFilter;
import org.opennms.web.event.filter.IPAddrLikeFilter;
import org.opennms.web.event.filter.IfIndexFilter;
import org.opennms.web.event.filter.InterfaceFilter;
import org.opennms.web.event.filter.LocationFilter;
import org.opennms.web.event.filter.LogMessageMatchesAnyFilter;
import org.opennms.web.event.filter.NegativeAcknowledgedByFilter;
import org.opennms.web.event.filter.NegativeEventTextFilter;
import org.opennms.web.event.filter.NegativeExactUEIFilter;
import org.opennms.web.event.filter.NegativeIPAddrLikeFilter;
import org.opennms.web.event.filter.NegativeInterfaceFilter;
import org.opennms.web.event.filter.NegativeLocationFilter;
import org.opennms.web.event.filter.NegativeNodeFilter;
import org.opennms.web.event.filter.NegativeNodeLocationFilter;
import org.opennms.web.event.filter.NegativeNodeNameLikeFilter;
import org.opennms.web.event.filter.NegativePartialUEIFilter;
import org.opennms.web.event.filter.NegativeServiceFilter;
import org.opennms.web.event.filter.NegativeSeverityFilter;
import org.opennms.web.event.filter.NegativeSystemIdFilter;
import org.opennms.web.event.filter.NodeFilter;
import org.opennms.web.event.filter.NodeLocationFilter;
import org.opennms.web.event.filter.NodeNameLikeFilter;
import org.opennms.web.event.filter.PartialUEIFilter;
import org.opennms.web.event.filter.ServiceOrFilter;
import org.opennms.web.event.filter.SeverityOrFilter;
import org.opennms.web.event.filter.SystemIdFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.utils.filter.CheckboxFilterUtils;
import org.opennms.web.utils.filter.FilterTokenizeUtils;

public abstract class EventUtil {
    private static final String NEGATION_PREFIX_SYMBOL = "!";
    private static final String ARRAY_DELIMITER = ",";
    public static final String ANY_OPTION = "Any";
    public static final int LAST_HOUR_RELATIVE_TIME = 1;
    public static final int LAST_FOUR_HOURS_RELATIVE_TIME = 2;
    public static final int LAST_EIGHT_HOURS_RELATIVE_TIME = 3;
    public static final int LAST_TWELVE_HOURS_RELATIVE_TIME = 4;
    public static final int LAST_DAY_RELATIVE_TIME = 5;
    public static final int LAST_WEEK_RELATIVE_TIME = 6;
    public static final int LAST_MONTH_RELATIVE_TIME = 7;

    public static boolean isInteger(String str) {
        return str != null && !str.isEmpty() && str.chars().allMatch(Character::isDigit);
    }

    public static Filter getFilter(String filterString, ServletContext servletContext) {
        if (filterString == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter filter = null;
        String[] tokenizedFilterString = FilterTokenizeUtils.tokenizeFilterString(filterString);
        String type = tokenizedFilterString[0];
        String value = tokenizedFilterString[1];
        if (type.equals("severity")) {
            String[] ids = value.split(ARRAY_DELIMITER);
            OnmsSeverity[] severities = new OnmsSeverity[ids.length];
            for (int index = 0; index < ids.length; ++index) {
                severities[index] = OnmsSeverity.get((int)WebSecurityUtils.safeParseInt((String)ids[index]));
            }
            filter = new SeverityOrFilter(severities);
        } else if (type.equals("node")) {
            filter = new NodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("nodenamelike")) {
            filter = value.startsWith(NEGATION_PREFIX_SYMBOL) ? new NegativeNodeNameLikeFilter(value.substring(1)) : new NodeNameLikeFilter(value);
        } else if (type.equals("interface")) {
            filter = new InterfaceFilter(value);
        } else if (type.equals("conditionalFilter")) {
            String cleanedValue = value.substring(1, value.length() - 1);
            String[] ids = cleanedValue.split(ARRAY_DELIMITER);
            boolean hasInteger = false;
            ArrayList<Integer> serviceIdsList = new ArrayList<Integer>();
            ArrayList<OnmsSeverity> severitiesList = new ArrayList<OnmsSeverity>();
            for (String id : ids) {
                String trimmedId = id.trim();
                if (EventUtil.isInteger(trimmedId)) {
                    hasInteger = true;
                    serviceIdsList.add(WebSecurityUtils.safeParseInt((String)trimmedId));
                    continue;
                }
                severitiesList.add(OnmsSeverity.get((String)trimmedId));
            }
            if (hasInteger) {
                Integer[] serviceIds = serviceIdsList.toArray(new Integer[0]);
                filter = new ServiceOrFilter(serviceIds, servletContext);
            } else {
                OnmsSeverity[] severities = severitiesList.toArray(new OnmsSeverity[0]);
                filter = new SeverityOrFilter(severities);
            }
        } else if (type.equals("service")) {
            String[] ids = value.split(ARRAY_DELIMITER);
            Integer[] serviceIds = new Integer[ids.length];
            for (int index = 0; index < ids.length; ++index) {
                serviceIds[index] = WebSecurityUtils.safeParseInt((String)ids[index]);
            }
            filter = new ServiceOrFilter(serviceIds, servletContext);
        } else if (type.equals("ifindex")) {
            filter = new IfIndexFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("partialUei")) {
            filter = new PartialUEIFilter(value);
        } else if (type.equals("exactUei")) {
            filter = new ExactUEIFilter(value);
        } else if (type.equals("acknowledgedBy")) {
            filter = new AcknowledgedByFilter(value);
        } else if (type.equals("severityNot")) {
            filter = new NegativeSeverityFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("nodenot")) {
            filter = new NegativeNodeFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("interfacenot")) {
            filter = new NegativeInterfaceFilter(value);
        } else if (type.equals("servicenot")) {
            filter = new NegativeServiceFilter(WebSecurityUtils.safeParseInt((String)value), servletContext);
        } else if (type.equals("partialUeiNot")) {
            filter = new NegativePartialUEIFilter(value);
        } else if (type.equals("exactUeiNot")) {
            filter = new NegativeExactUEIFilter(value);
        } else if (type.equals("acknowledgedByNot")) {
            filter = new NegativeAcknowledgedByFilter(value);
        } else if (type.equals("eventId")) {
            filter = new EventIdFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("iplike")) {
            filter = value.startsWith(NEGATION_PREFIX_SYMBOL) ? new NegativeIPAddrLikeFilter(value.substring(1)) : new IPAddrLikeFilter(value);
        } else if (type.equals("eventtext")) {
            filter = value.startsWith(NEGATION_PREFIX_SYMBOL) ? new NegativeEventTextFilter(value.substring(1)) : new EventTextFilter(value);
        } else if (type.equals("msgmatchany")) {
            filter = new LogMessageMatchesAnyFilter(value);
        } else if (type.equals("beforedate")) {
            filter = new BeforeDateFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("afterdate")) {
            filter = new AfterDateFilter(WebSecurityUtils.safeParseLong((String)value));
        } else if (type.equals("alarm")) {
            filter = new AlarmIDFilter(WebSecurityUtils.safeParseInt((String)value));
        } else if (type.equals("location")) {
            filter = new LocationFilter(WebSecurityUtils.sanitizeString((String)value));
        } else if (type.equals("systemId")) {
            if (!value.equalsIgnoreCase(ANY_OPTION)) {
                filter = new SystemIdFilter(WebSecurityUtils.sanitizeString((String)value));
            }
        } else if (type.equals("locationnot")) {
            filter = new NegativeLocationFilter(WebSecurityUtils.sanitizeString((String)value));
        } else if (type.equals("systemIdNot")) {
            filter = new NegativeSystemIdFilter(WebSecurityUtils.sanitizeString((String)value));
        } else if (type.equals("nodelocation")) {
            if (!value.equalsIgnoreCase(ANY_OPTION)) {
                filter = new NodeLocationFilter(WebSecurityUtils.sanitizeString((String)value));
            }
        } else if (type.equals("nodelocationnot")) {
            filter = new NegativeNodeLocationFilter(WebSecurityUtils.sanitizeString((String)value));
        }
        return filter;
    }

    public static String getFilterString(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return filter.getDescription();
    }

    public static Filter getRelativeTimeFilter(int relativeTime) {
        AfterDateFilter filter = null;
        Calendar now = Calendar.getInstance();
        switch (relativeTime) {
            case 1: {
                now.add(10, -1);
                break;
            }
            case 2: {
                now.add(10, -4);
                break;
            }
            case 3: {
                now.add(10, -8);
                break;
            }
            case 4: {
                now.add(10, -12);
                break;
            }
            case 5: {
                now.add(10, -24);
                break;
            }
            case 6: {
                now.add(10, -168);
                break;
            }
            case 7: {
                now.add(2, -1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown relative time constant: " + relativeTime);
            }
        }
        filter = new AfterDateFilter(now.getTime());
        return filter;
    }

    public static List<Filter> getFilterList(String[] filterStrings, ServletContext servletContext) {
        filterStrings = CheckboxFilterUtils.handleCheckboxDuplication(filterStrings);
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (filterStrings != null) {
            for (String filterString : filterStrings) {
                Filter filter = EventUtil.getFilter(filterString, servletContext);
                if (filter == null) continue;
                filterList.add(filter);
            }
        }
        return filterList;
    }
}

