/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.web.controller.ksc.KscReportEditor;
import org.opennms.web.graph.KscResultSet;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.svclayer.api.KscReportService;
import org.opennms.web.svclayer.api.ResourceService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class CustomGraphEditDetailsController
extends AbstractController
implements InitializingBean {
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private KscReportService m_kscReportService;
    private ResourceService m_resourceService;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String resourceId = request.getParameter(Parameters.resourceId.toString());
        if (resourceId == null) {
            throw new MissingParameterException(Parameters.resourceId.toString());
        }
        String prefabReportName = request.getParameter(Parameters.graphtype.toString());
        KscReportEditor editor = KscReportEditor.getFromSession(request.getSession(), true);
        Report report = editor.getWorkingReport();
        Graph sample_graph = editor.getWorkingGraph();
        if (sample_graph == null) {
            throw new IllegalArgumentException("Invalid working graph argument -- null pointer. Possibly missing prefab report in snmp-graph.properties?");
        }
        sample_graph.setResourceId(resourceId);
        OnmsResource resource = this.getKscReportService().getResourceFromGraph(sample_graph);
        PrefabGraph[] graph_options = this.getResourceService().findPrefabGraphsForResource(resource);
        PrefabGraph display_graph = null;
        if (graph_options.length > 0) {
            display_graph = prefabReportName == null ? graph_options[0] : this.getPrefabGraphFromList(graph_options, sample_graph.getGraphtype());
        }
        Calendar begin_time = Calendar.getInstance();
        Calendar end_time = Calendar.getInstance();
        KSC_PerformanceReportFactory.getBeginEndTime((String)sample_graph.getTimespan(), (Calendar)begin_time, (Calendar)end_time);
        KscResultSet resultSet = new KscResultSet(sample_graph.getTitle(), begin_time.getTime(), end_time.getTime(), resource, display_graph);
        ModelAndView modelAndView = new ModelAndView("KSC/customGraphEditDetails");
        modelAndView.addObject("resultSet", (Object)resultSet);
        modelAndView.addObject("prefabGraphs", (Object)graph_options);
        modelAndView.addObject("timeSpans", (Object)this.getKscReportService().getTimeSpans(false));
        modelAndView.addObject("timeSpan", (Object)sample_graph.getTimespan());
        int graph_index = editor.getWorkingGraphIndex();
        int max_graphs = report.getGraphs().size();
        if (graph_index == -1) {
            graph_index = max_graphs++;
        }
        modelAndView.addObject("graphIndex", (Object)graph_index);
        modelAndView.addObject("maxGraphIndex", (Object)max_graphs);
        return modelAndView;
    }

    public PrefabGraph getPrefabGraphFromList(PrefabGraph[] graphs, String name) {
        for (PrefabGraph graph : graphs) {
            if (!graph.getName().equals(name)) continue;
            return graph;
        }
        return null;
    }

    public ResourceService getResourceService() {
        return this.m_resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.m_resourceService = resourceService;
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_resourceService != null ? 1 : 0) != 0, (String)"property resourceService must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
    }

    public static enum Parameters {
        resourceId,
        graphtype;

    }
}

