/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.commands;

import java.io.IOException;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.opennms.features.jmxconfiggenerator.commands.JmxCommand;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.FilterCriteria;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.MBeanServerQuery;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.MBeanServerQueryException;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.QueryResult;

public class QueryCommand
extends JmxCommand {
    @Option(name="--show-empty", usage="Includes MBeans, even if they do not have Attributes. Either due to the <filter criteria> or while there are none.")
    private boolean all;
    @Option(name="--ignore", usage="Set <filter criteria> to ignore while running.")
    private List<String> ignoreFilter;
    @Argument(metaVar="<filter criteria>", usage="A filter criteria to query the MBeanServer for. The format is <objectname>[:attribute name]. The <objectname> accepts the default JMX object name pattern to identify the MBeans to be retrieved. If null all domains are shown. If no key properties are specified, the domain's MBeans are retrieved. To execute for certain attributes, you have to add \":<attribute name>\". The <attribute name> accepts regular expressions. When multiple <filter criteria> are provided they are OR concatenated. ")
    private List<String> filter;
    @Option(name="--ids-only", usage="Only show the ids of the attributes.")
    private boolean idOnlyFlag;
    @Option(name="--include-values", usage="Include attribute values.", required=false)
    private boolean includeValues = false;
    @Option(name="--show-domains", usage="Only lists the available domains.")
    private boolean domainOnlyFlag = true;

    @Override
    protected void execute(MBeanServerConnection mbeanServerConnection) throws MBeanServerQueryException, IOException {
        if (this.domainOnlyFlag && (this.filter == null || this.filter.isEmpty())) {
            for (String eachDomain : mbeanServerConnection.getDomains()) {
                this.LOG.info(eachDomain, new Object[0]);
            }
            return;
        }
        MBeanServerQuery queryBuilder = new MBeanServerQuery().withFilters(this.filter).withIgnoresFilter(this.ignoreFilter).fetchValues(this.includeValues).showMBeansWithoutAttributes(this.all).sort(true);
        QueryResult result = queryBuilder.execute(mbeanServerConnection);
        if (this.idOnlyFlag) {
            for (QueryResult.MBeanResult eachResult : result.getMBeanResults()) {
                for (MBeanAttributeInfo eachAttributeInfo : eachResult.attributeResult.attributes) {
                    this.LOG.info(this.toAttributeId(eachResult.objectName, eachAttributeInfo), new Object[0]);
                }
            }
        } else {
            this.prettyPrint(result);
        }
    }

    private void prettyPrint(QueryResult result) {
        for (QueryResult.MBeanResult eachMBeanResult : result.getMBeanResults()) {
            MBeanInfo mbeanInfo = eachMBeanResult.mbeanInfo;
            ObjectName objectName = eachMBeanResult.objectName;
            QueryResult.AttributeResult attributeResult = eachMBeanResult.attributeResult;
            this.LOG.info(String.format("%s", objectName), new Object[0]);
            this.LOG.info(String.format("\tdescription: %s", this.toString(mbeanInfo.getDescription())), new Object[0]);
            this.LOG.info(String.format("\tclass name: %s", mbeanInfo.getClassName()), new Object[0]);
            this.LOG.info(String.format("\tattributes: (%d/%d)", attributeResult.attributes.size(), attributeResult.totalCount), new Object[0]);
            for (MBeanAttributeInfo eachAttribute : attributeResult.attributes) {
                this.LOG.info(String.format("\t\t%s", eachAttribute.getName()), new Object[0]);
                this.LOG.info(String.format("\t\t\tid: %s", this.toAttributeId(objectName, eachAttribute)), new Object[0]);
                this.LOG.info(String.format("\t\t\tdescription: %s", this.toString(eachAttribute.getDescription())), new Object[0]);
                this.LOG.info(String.format("\t\t\ttype: %s", eachAttribute.getType()), new Object[0]);
                this.LOG.info(String.format("\t\t\tisReadable: %s", eachAttribute.isReadable()), new Object[0]);
                this.LOG.info(String.format("\t\t\tisWritable: %s", eachAttribute.isWritable()), new Object[0]);
                this.LOG.info(String.format("\t\t\tisIs: %s", eachAttribute.isIs()), new Object[0]);
                if (!this.includeValues) continue;
                this.LOG.info(String.format("\t\t\tvalue: %s", this.toString(attributeResult.getValue(eachAttribute))), new Object[0]);
            }
        }
        if (this.filter != null && !this.filter.isEmpty()) {
            this.LOG.info(String.format("Your query '%s' shows %d/%d MBeans.", this.filter, result.getMBeanResults().size(), result.getTotalMBeanCount()), new Object[0]);
        } else {
            this.LOG.info(String.format("There are %d registered MBeans", result.getTotalMBeanCount()), new Object[0]);
        }
        if (this.ignoreFilter != null && !this.ignoreFilter.isEmpty()) {
            this.LOG.info(String.format("While querying, the following query was used to exclude MBeans/Attributes: '%s'", this.ignoreFilter), new Object[0]);
        }
    }

    @Override
    public void printUsage() {
        super.printUsage();
        this.LOG.info("", new Object[0]);
        this.LOG.info("Examples:", new Object[0]);
        this.LOG.info(" Querying: java-jar JmxConfigGenerator.jar query --host localhost --port 7199 [--ids-only] [--show-domains] [--ignore <filter criteria>] [--include-values] <filter criteria>", new Object[0]);
        this.LOG.info(" Show domains: java-jar JmxConfigGenerator.jar query --host localhost --port 7199 [--show-domains]", new Object[0]);
        this.LOG.info(" Show all MBeans/Attributes of a domain: java-jar JmxConfigGenerator.jar query --host localhost --port 7199 org.opennms.domain1:*", new Object[0]);
        this.LOG.info(" Show all MBeans/Attributes of a domain, but exclude MBeans/Attributes of another: java-jar JmxConfigGenerator.jar query --host localhost --port 7199 org.opennms.domain1:* --ignore java.lang*:*", new Object[0]);
        this.LOG.info(" Only show ids: java -jar JmxConfigGenerator.jar query --host localhost --port 7199 --ids-only", new Object[0]);
        this.LOG.info(" Query for certain Attributes: java -jar JmxConfigGenerator.jar query --host localhost --port 7199 org.opennms.domain1:Status.*", new Object[0]);
    }

    @Override
    protected String getDescription() {
        return "Enables querying the MBeanServer for certain MBeans/attributes.";
    }

    private String cut(String input, int length) {
        if (input.length() > length) {
            return input.substring(0, length);
        }
        return input;
    }

    private String toString(Object input) {
        if (input != null && input instanceof String) {
            return this.cut(input.toString().replaceAll("\n", ""), 200);
        }
        return input == null ? null : input.toString();
    }

    private String toAttributeId(ObjectName objectName, MBeanAttributeInfo attributeInfo) {
        return new FilterCriteria(objectName.toString(), attributeInfo.getName()).toString();
    }
}

