/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.impl;

import java.util.Map;
import org.apache.karaf.profile.PlaceholderResolver;
import org.osgi.framework.BundleContext;

public final class PlaceholderResolvers {
    private PlaceholderResolvers() {
    }

    public static String substituteProfileProperty(String key, Map<String, Map<String, String>> configs) {
        String pid = key.substring("profile:".length(), key.indexOf("/"));
        String propertyKey = key.substring(key.indexOf("/") + 1);
        Map<String, String> targetProps = configs.get(pid);
        if (targetProps != null && targetProps.containsKey(propertyKey)) {
            return targetProps.get(propertyKey);
        }
        return key;
    }

    public static String substituteBundleProperty(String key, BundleContext bundleContext) {
        String value = null;
        if (bundleContext != null) {
            value = bundleContext.getProperty(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        return value != null ? value : "";
    }

    public static class ProfilePlaceholderResolver
    implements PlaceholderResolver {
        public final String SCHEME = "profile";

        @Override
        public String getScheme() {
            return "profile";
        }

        @Override
        public String resolve(Map<String, Map<String, String>> profile, String pid, String key, String value) {
            int index = value.indexOf("/");
            if (index >= 0) {
                String propertyPid = value.substring(0, index);
                String propertyKey = value.substring(index + 1);
                Map<String, String> props = profile.get(propertyPid);
                if (props != null && props.containsKey(propertyKey)) {
                    String v = props.get(propertyKey);
                    return v.toString();
                }
            }
            return null;
        }
    }
}

