/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.sa;

import java.net.InetAddress;
import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.internal.msg.RequestMessage;
import org.sblim.slp.internal.msg.SLPMessage;

public class MessageTable {
    private static final long KEEPIN = 30L;
    private SortedMap iTimeMap = new TreeMap();
    private SortedMap iReqMap = new TreeMap();

    public synchronized byte[] getResponse(InetAddress pSource, SLPMessage pRequest) throws ServiceLocationException {
        long now = MessageTable.getSecs();
        RequestDescriptor reqDesc = new RequestDescriptor(pSource, pRequest);
        TableEntry entry = (TableEntry)this.iReqMap.get(reqDesc);
        if (entry == null) {
            return null;
        }
        this.clean();
        this.updateTime(entry, now);
        return entry.getResponse();
    }

    public synchronized void addResponse(InetAddress pSource, SLPMessage pRequest, byte[] pRespond) throws ServiceLocationException {
        this.insert(new TableEntry(MessageTable.getSecs(), new RequestDescriptor(pSource, pRequest), pRespond));
        this.clean();
    }

    private void clean() {
        Long timeStamp;
        long now = MessageTable.getSecs();
        while ((timeStamp = (Long)this.iTimeMap.firstKey()) != null && now - timeStamp >= 30L) {
            TableEntry entry = (TableEntry)this.iTimeMap.get(timeStamp);
            this.remove(entry);
        }
    }

    private void insert(TableEntry pEntry) {
        this.iTimeMap.put(new Long(pEntry.getTime()), pEntry);
        this.iReqMap.put(pEntry.getRequestDescriptor(), pEntry);
    }

    private void remove(TableEntry pEntry) {
        this.iTimeMap.remove(new Long(pEntry.getTime()));
        this.iReqMap.remove(pEntry.getRequestDescriptor());
    }

    private void updateTime(TableEntry pEntry, long pTime) {
        this.remove(pEntry);
        pEntry.setTime(pTime);
        this.insert(pEntry);
    }

    private static long getSecs() {
        return new Date().getTime() / 1000L;
    }

    private static class TableEntry {
        private long iTime;
        private RequestDescriptor iReqDesc;
        private byte[] iResponse;

        public TableEntry(long pTime, RequestDescriptor pReqKey, byte[] pResponse) {
            this.iTime = pTime;
            this.iReqDesc = pReqKey;
            this.iResponse = pResponse;
        }

        public long getTime() {
            return this.iTime;
        }

        public void setTime(long pTime) {
            this.iTime = pTime;
        }

        public RequestDescriptor getRequestDescriptor() {
            return this.iReqDesc;
        }

        public byte[] getResponse() {
            return this.iResponse;
        }
    }

    private static class RequestDescriptor
    implements Comparable {
        private byte[] iSrcAddress;
        private byte[] iRequest;

        public RequestDescriptor(InetAddress pSource, SLPMessage pRequest) throws ServiceLocationException {
            this.iSrcAddress = pSource.getAddress();
            this.iRequest = pRequest instanceof RequestMessage ? ((RequestMessage)pRequest).serializeWithoutResponders(false, true, true) : pRequest.serialize(false, true, true);
        }

        public int compareTo(Object pObj) {
            RequestDescriptor that = (RequestDescriptor)pObj;
            int cmp = RequestDescriptor.compare(this.iSrcAddress, that.iSrcAddress);
            if (cmp != 0) {
                return cmp;
            }
            return RequestDescriptor.compare(this.iRequest, that.iRequest);
        }

        private static int compare(byte[] pBytes0, byte[] pBytes1) {
            int len = Math.min(pBytes0.length, pBytes1.length);
            for (int i = 0; i < len; ++i) {
                int cmp = pBytes0[i] & 255 - pBytes1[i] & 0xFF;
                if (cmp == 0) continue;
                return cmp;
            }
            return pBytes0.length - pBytes1.length;
        }
    }
}

