/*
 * Decompiled with CFR 0.152.
 */
package com.swrve.ratelimitedlogger;

import com.swrve.ratelimitedlogger.CounterMetric;
import com.swrve.ratelimitedlogger.Level;
import com.swrve.ratelimitedlogger.LogWithPatternAndLevel;
import com.swrve.ratelimitedlogger.RateLimitedLogBuilder;
import com.swrve.ratelimitedlogger.RateLimitedLogWithPattern;
import com.swrve.ratelimitedlogger.Registry;
import com.swrve.ratelimitedlogger.Stopwatch;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.Marker;

@ThreadSafe
public class RateLimitedLog
implements Logger {
    static final Registry REGISTRY = new Registry();
    static final int MAX_PATTERNS_PER_LOG = 1000;
    private static final int MAX_PATTERN_LENGTH = 8192;
    final ConcurrentHashMap<String, RateLimitedLogWithPattern> knownPatterns = new ConcurrentHashMap();
    private final Logger logger;
    private final RateLimitedLogWithPattern.RateAndPeriod rateAndPeriod;
    private final Registry registry;
    private final Stopwatch stopwatch;
    private final CounterMetric stats;

    public static RateLimitedLogBuilder.MissingRateAndPeriod withRateLimit(Logger logger) {
        return new RateLimitedLogBuilder.MissingRateAndPeriod(Objects.requireNonNull(logger));
    }

    RateLimitedLog(Logger logger, RateLimitedLogWithPattern.RateAndPeriod rateAndPeriod, Stopwatch stopwatch, CounterMetric stats, Registry registry) {
        this.logger = logger;
        this.rateAndPeriod = rateAndPeriod;
        this.registry = registry;
        this.stats = stats;
        this.stopwatch = stopwatch;
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        this.get(msg).trace(msg);
    }

    public void trace(String format, Object arg) {
        this.get(format).trace(arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.get(format).trace(arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.get(format).trace(arguments);
    }

    public void trace(String msg, Throwable t) {
        this.get(msg).trace(t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.get(msg).trace(marker, new Object[]{msg});
    }

    public void trace(Marker marker, String format, Object arg) {
        this.get(format).trace(marker, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.get(format).trace(marker, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.get(format).trace(marker, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.get(msg).trace(marker, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.get(msg).debug(msg);
    }

    public void debug(String format, Object arg) {
        this.get(format).debug(arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.get(format).debug(arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.get(format).debug(arguments);
    }

    public void debug(String msg, Throwable t) {
        this.get(msg).debug(t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.get(msg).debug(marker, new Object[]{msg});
    }

    public void debug(Marker marker, String format, Object arg) {
        this.get(format).debug(marker, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.get(format).debug(marker, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... argArray) {
        this.get(format).debug(marker, argArray);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.get(msg).debug(marker, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        this.get(msg).info(msg);
    }

    public void info(String format, Object arg) {
        this.get(format).info(arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.get(format).info(arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.get(format).info(arguments);
    }

    public void info(String msg, Throwable t) {
        this.get(msg).info(t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.get(msg).info(marker, new Object[]{msg});
    }

    public void info(Marker marker, String format, Object arg) {
        this.get(format).info(marker, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.get(format).info(marker, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... argArray) {
        this.get(format).info(marker, argArray);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.get(msg).info(marker, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        this.get(msg).warn(msg);
    }

    public void warn(String format, Object arg) {
        this.get(format).warn(arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.get(format).warn(arg1, arg2);
    }

    public void warn(String format, Object ... arguments) {
        this.get(format).warn(arguments);
    }

    public void warn(String msg, Throwable t) {
        this.get(msg).warn(t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.get(msg).warn(marker, new Object[]{msg});
    }

    public void warn(Marker marker, String format, Object arg) {
        this.get(format).warn(marker, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.get(format).warn(marker, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... argArray) {
        this.get(format).warn(marker, argArray);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.get(msg).warn(marker, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String msg) {
        this.get(msg).error(msg);
    }

    public void error(String format, Object arg) {
        this.get(format).error(arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.get(format).error(arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.get(format).error(arguments);
    }

    public void error(String msg, Throwable t) {
        this.get(msg).error(t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.get(msg).error(marker, new Object[]{msg});
    }

    public void error(Marker marker, String format, Object arg) {
        this.get(format).error(marker, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.get(format).error(marker, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... argArray) {
        this.get(format).error(marker, argArray);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.get(msg).error(marker, t);
    }

    public RateLimitedLogWithPattern get(String message) {
        RateLimitedLogWithPattern newValue;
        RateLimitedLogWithPattern oldValue;
        String key = message.length() > 8192 ? message.substring(0, 8192) : message;
        RateLimitedLogWithPattern got = this.knownPatterns.get(key);
        if (got != null) {
            return got;
        }
        if (this.knownPatterns.size() > 1000) {
            this.outOfCacheCapacity();
        }
        if ((oldValue = this.knownPatterns.putIfAbsent(key, newValue = new RateLimitedLogWithPattern(message, this.rateAndPeriod, this.registry, this.stats, this.stopwatch, this.logger))) != null) {
            return oldValue;
        }
        return newValue;
    }

    public LogWithPatternAndLevel get(String pattern, Level level) {
        return this.get(pattern).get(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outOfCacheCapacity() {
        ConcurrentHashMap<String, RateLimitedLogWithPattern> concurrentHashMap = this.knownPatterns;
        synchronized (concurrentHashMap) {
            if (this.knownPatterns.size() > 1000) {
                this.logger.warn("out of capacity in RateLimitedLog registry; accidentally using interpolated strings as patterns?");
                this.registry.flush();
                this.knownPatterns.clear();
            }
        }
    }
}

