/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.sqlcontainer.query.generator;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.sqlcontainer.ColumnProperty;
import com.vaadin.v7.data.util.sqlcontainer.RowItem;
import com.vaadin.v7.data.util.sqlcontainer.SQLUtil;
import com.vaadin.v7.data.util.sqlcontainer.TemporaryRowId;
import com.vaadin.v7.data.util.sqlcontainer.query.OrderBy;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.MSSQLGenerator;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.OracleGenerator;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.SQLGenerator;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.StatementHelper;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.filter.QueryBuilder;
import com.vaadin.v7.data.util.sqlcontainer.query.generator.filter.StringDecorator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Deprecated
public class DefaultSQLGenerator
implements SQLGenerator {
    private Class<? extends StatementHelper> statementHelperClass = null;

    public DefaultSQLGenerator() {
    }

    public DefaultSQLGenerator(Class<? extends StatementHelper> statementHelperClazz) {
        this();
        this.statementHelperClass = statementHelperClazz;
    }

    public DefaultSQLGenerator(String quoteStart, String quoteEnd) {
        QueryBuilder.setStringDecorator(new StringDecorator(quoteStart, quoteEnd));
    }

    public DefaultSQLGenerator(String quoteStart, String quoteEnd, Class<? extends StatementHelper> statementHelperClazz) {
        this(quoteStart, quoteEnd);
        this.statementHelperClass = statementHelperClazz;
    }

    @Override
    public StatementHelper generateSelectQuery(String tableName, List<Container.Filter> filters, List<OrderBy> orderBys, int offset, int pagelength, String toSelect) {
        if (tableName == null || tableName.trim().equals("")) {
            throw new IllegalArgumentException("Table name must be given.");
        }
        toSelect = toSelect == null ? "*" : toSelect;
        StatementHelper sh = this.getStatementHelper();
        StringBuffer query = new StringBuffer();
        query.append("SELECT " + toSelect + " FROM ").append(SQLUtil.escapeSQL(tableName));
        if (filters != null) {
            query.append(QueryBuilder.getWhereStringForFilters(filters, sh));
        }
        if (orderBys != null) {
            for (OrderBy o : orderBys) {
                this.generateOrderBy(query, o, orderBys.indexOf(o) == 0);
            }
        }
        if (pagelength != 0) {
            this.generateLimits(query, offset, pagelength);
        }
        sh.setQueryString(query.toString());
        return sh;
    }

    @Override
    public StatementHelper generateUpdateQuery(String tableName, RowItem item) {
        if (tableName == null || tableName.trim().equals("")) {
            throw new IllegalArgumentException("Table name must be given.");
        }
        if (item == null) {
            throw new IllegalArgumentException("Updated item must be given.");
        }
        StatementHelper sh = this.getStatementHelper();
        StringBuilder query = new StringBuilder();
        query.append("UPDATE ").append(tableName).append(" SET");
        Map<String, Object> columnToValueMap = this.generateColumnToValueMap(item);
        Map<String, Object> rowIdentifiers = this.generateRowIdentifiers(item);
        boolean first = true;
        for (String column : columnToValueMap.keySet()) {
            if (first) {
                query.append(" " + QueryBuilder.quote(column) + " = ?");
            } else {
                query.append(", " + QueryBuilder.quote(column) + " = ?");
            }
            sh.addParameterValue(columnToValueMap.get(column), item.getItemProperty(column).getType());
            first = false;
        }
        first = true;
        for (String column : rowIdentifiers.keySet()) {
            if (first) {
                query.append(" WHERE " + QueryBuilder.quote(column) + " = ?");
            } else {
                query.append(" AND " + QueryBuilder.quote(column) + " = ?");
            }
            sh.addParameterValue(rowIdentifiers.get(column), item.getItemProperty(column).getType());
            first = false;
        }
        sh.setQueryString(query.toString());
        return sh;
    }

    @Override
    public StatementHelper generateInsertQuery(String tableName, RowItem item) {
        if (tableName == null || tableName.trim().equals("")) {
            throw new IllegalArgumentException("Table name must be given.");
        }
        if (item == null) {
            throw new IllegalArgumentException("New item must be given.");
        }
        if (!(item.getId() instanceof TemporaryRowId)) {
            throw new IllegalArgumentException("Cannot generate an insert query for item already in database.");
        }
        StatementHelper sh = this.getStatementHelper();
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO ").append(tableName).append(" (");
        Map<String, Object> columnToValueMap = this.generateColumnToValueMap(item);
        boolean first = true;
        for (String column : columnToValueMap.keySet()) {
            if (!first) {
                query.append(", ");
            }
            query.append(QueryBuilder.quote(column));
            first = false;
        }
        query.append(") VALUES (");
        first = true;
        for (String column : columnToValueMap.keySet()) {
            if (!first) {
                query.append(", ");
            }
            query.append('?');
            sh.addParameterValue(columnToValueMap.get(column), item.getItemProperty(column).getType());
            first = false;
        }
        query.append(')');
        sh.setQueryString(query.toString());
        return sh;
    }

    @Override
    public StatementHelper generateDeleteQuery(String tableName, List<String> primaryKeyColumns, String versionColumn, RowItem item) {
        if (tableName == null || tableName.trim().equals("")) {
            throw new IllegalArgumentException("Table name must be given.");
        }
        if (item == null) {
            throw new IllegalArgumentException("Item to be deleted must be given.");
        }
        if (primaryKeyColumns == null || primaryKeyColumns.isEmpty()) {
            throw new IllegalArgumentException("Valid keyColumnNames must be provided.");
        }
        StatementHelper sh = this.getStatementHelper();
        StringBuilder query = new StringBuilder();
        query.append("DELETE FROM ").append(tableName).append(" WHERE ");
        int count = 1;
        for (String keyColName : primaryKeyColumns) {
            if ((this instanceof MSSQLGenerator || this instanceof OracleGenerator) && keyColName.equalsIgnoreCase("rownum")) {
                ++count;
                continue;
            }
            if (count > 1) {
                query.append(" AND ");
            }
            if (item.getItemProperty(keyColName).getValue() != null) {
                query.append(QueryBuilder.quote(keyColName) + " = ?");
                sh.addParameterValue(item.getItemProperty(keyColName).getValue(), item.getItemProperty(keyColName).getType());
            }
            ++count;
        }
        if (versionColumn != null) {
            if (!item.getItemPropertyIds().contains(versionColumn)) {
                throw new IllegalArgumentException(String.format("Table '%s' does not contain version column '%s'.", tableName, versionColumn));
            }
            query.append(String.format(" AND %s = ?", QueryBuilder.quote(versionColumn)));
            sh.addParameterValue(item.getItemProperty(versionColumn).getValue(), item.getItemProperty(versionColumn).getType());
        }
        sh.setQueryString(query.toString());
        return sh;
    }

    protected StringBuffer generateOrderBy(StringBuffer sb, OrderBy o, boolean firstOrderBy) {
        if (firstOrderBy) {
            sb.append(" ORDER BY ");
        } else {
            sb.append(", ");
        }
        sb.append(QueryBuilder.quote(o.getColumn()));
        if (o.isAscending()) {
            sb.append(" ASC");
        } else {
            sb.append(" DESC");
        }
        return sb;
    }

    protected StringBuffer generateLimits(StringBuffer sb, int offset, int pagelength) {
        sb.append(" LIMIT ").append(pagelength).append(" OFFSET ").append(offset);
        return sb;
    }

    protected Map<String, Object> generateColumnToValueMap(RowItem item) {
        HashMap<String, Object> columnToValueMap = new HashMap<String, Object>();
        for (Object id : item.getItemPropertyIds()) {
            ColumnProperty cp = (ColumnProperty)item.getItemProperty(id);
            if ((this instanceof MSSQLGenerator || this instanceof OracleGenerator) && cp.getPropertyId().equalsIgnoreCase("rownum") || !cp.isPersistent()) continue;
            columnToValueMap.put(cp.getPropertyId(), cp.getValue());
        }
        return columnToValueMap;
    }

    protected Map<String, Object> generateRowIdentifiers(RowItem item) {
        HashMap<String, Object> rowIdentifiers = new HashMap<String, Object>();
        for (Object id : item.getItemPropertyIds()) {
            ColumnProperty cp = (ColumnProperty)item.getItemProperty(id);
            if ((this instanceof MSSQLGenerator || this instanceof OracleGenerator) && cp.getPropertyId().equalsIgnoreCase("rownum") || !cp.isRowIdentifier()) continue;
            Object value = cp.isPrimaryKey() ? cp.getOldValue() : cp.getValue();
            rowIdentifiers.put(cp.getPropertyId(), value);
        }
        return rowIdentifiers;
    }

    protected StatementHelper getStatementHelper() {
        if (this.statementHelperClass == null) {
            return new StatementHelper();
        }
        try {
            return this.statementHelperClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate custom StatementHelper", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate custom StatementHelper", e);
        }
    }
}

