/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.vmware;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.opennms.netmgt.config.vmware.VmwareServer;
import org.opennms.netmgt.dao.vmware.VmwareConfigDao;
import org.opennms.netmgt.provision.persist.AbstractRequisitionProvider;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.vmware.VmwareImportRequest;
import org.opennms.netmgt.provision.service.vmware.VmwareImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class VmwareRequisitionProvider
extends AbstractRequisitionProvider<VmwareImportRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(VmwareRequisitionProvider.class);
    public static final String TYPE_NAME = "vmware";
    @Autowired
    @Qualifier(value="fileDeployed")
    private ForeignSourceRepository foreignSourceRepository;
    @Autowired
    private VmwareConfigDao vmwareConfigDao;

    public VmwareRequisitionProvider() {
        super(VmwareImportRequest.class);
    }

    public String getType() {
        return TYPE_NAME;
    }

    public VmwareImportRequest getRequest(Map<String, String> parameters) {
        Map<String, VmwareServer> serverMap;
        VmwareServer vmwareServer;
        VmwareImportRequest request = new VmwareImportRequest(parameters);
        if ((StringUtils.isBlank((String)request.getUsername()) || StringUtils.isBlank((String)request.getPassword())) && (vmwareServer = (serverMap = this.vmwareConfigDao.getServerMap()).get(request.getHostname())) != null) {
            request.setUsername(vmwareServer.getUsername());
            request.setPassword(vmwareServer.getPassword());
        }
        Requisition existingRequisition = this.getExistingRequisition(request.getForeignSource());
        request.setExistingRequisition(existingRequisition);
        return request;
    }

    public Requisition getRequisitionFor(VmwareImportRequest request) {
        VmwareImporter importer = new VmwareImporter(request);
        return importer.getRequisition();
    }

    protected Requisition getExistingRequisition(String foreignSource) {
        try {
            return this.foreignSourceRepository.getRequisition(foreignSource);
        }
        catch (Exception e) {
            LOG.warn("Can't retrieve requisition {}", (Object)foreignSource, (Object)e);
            return null;
        }
    }
}

