/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.topology.persistence.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opennms.netmgt.topology.persistence.api.PointEntity;
import org.opennms.netmgt.topology.persistence.api.VertexPositionEntity;

@Entity
@Table(name="topo_layout")
public class LayoutEntity {
    @Id
    @Column(nullable=false)
    private String id;
    @Column(name="created", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @Column(name="creator", nullable=false)
    private String creator;
    @Column(name="updated", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updated;
    @Column(name="updator", nullable=false)
    private String updator;
    @Column(name="last_used")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUsed;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    @JoinTable(name="topo_layout_vertex_positions", joinColumns={@JoinColumn(name="layout_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="vertex_position_id", referencedColumnName="id")})
    private List<VertexPositionEntity> vertexPositions = new ArrayList<VertexPositionEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public String getUpdator() {
        return this.updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public List<VertexPositionEntity> getVertexPositions() {
        return this.vertexPositions;
    }

    public void setVertexPositions(List<VertexPositionEntity> vertexPositions) {
        this.vertexPositions = vertexPositions;
    }

    public PointEntity getPosition(String namespace, String id) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(id);
        Optional<VertexPositionEntity> first = this.vertexPositions.stream().filter(e -> e.getVertexRef().getNamespace().equals(namespace) && e.getVertexRef().getId().equals(id)).findFirst();
        if (first.isPresent()) {
            VertexPositionEntity vertexPositionEntity = first.get();
            return vertexPositionEntity.getPosition();
        }
        return null;
    }

    public void addVertexPosition(VertexPositionEntity position) {
        Objects.requireNonNull(position);
        this.getVertexPositions().add(position);
    }

    public void setLastUsed(Date lastUsed) {
        this.lastUsed = lastUsed;
    }

    public Date getLastUsed() {
        return this.lastUsed;
    }
}

