/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.newts.converter;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;

public class SimpleDataSource
implements DataSource {
    private String m_driver;
    private String m_url;
    private Properties m_properties = new Properties();
    private Integer m_timeout = null;

    public SimpleDataSource(JdbcDataSource ds) throws ClassNotFoundException {
        this.m_driver = ds.getClassName();
        this.m_url = ds.getUrl();
        this.m_properties.put("user", ds.getUserName());
        this.m_properties.put("password", ds.getPassword());
        Class.forName(this.m_driver);
        for (Param param : ds.getParamCollection()) {
            this.m_properties.put(param.getName(), param.getValue());
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.m_timeout == null) {
            return DriverManager.getConnection(this.m_url, this.m_properties);
        }
        int oldTimeout = DriverManager.getLoginTimeout();
        DriverManager.setLoginTimeout(this.m_timeout);
        Connection conn = DriverManager.getConnection(this.m_url, this.m_properties);
        DriverManager.setLoginTimeout(oldTimeout);
        return conn;
    }

    public String getUrl() {
        return this.m_url;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("getConnection(String, String) not implemented");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new UnsupportedOperationException("getLogWriter() not implemented");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_timeout == null ? -1 : this.m_timeout;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter(PrintWriter) not implemented");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_timeout = seconds;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }
}

