/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.common.impl;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.vavr.control.Try;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.codehaus.jackson.map.ObjectMapper;
import org.opennms.core.xml.JacksonUtils;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.dao.common.api.ReloadableConfigContainer;

public class PollingJsonStoreReloadableConfigContainer<T>
implements ReloadableConfigContainer<T> {
    private final ObjectMapper mapper = JacksonUtils.createDefaultObjectMapper();
    private final JsonStore jsonStore;
    private final String key;
    private final String context;
    private final Class<T> entityClass;
    private final long pollingIntervalMs;
    private final Supplier<Optional<T>> retryableConfigSupplier;
    private long lastGotTime;
    private long lastCheckedTime;
    private T config;

    public PollingJsonStoreReloadableConfigContainer(JsonStore jsonStore, String key, String context, Class<T> entityClass, long pollingIntervalMs, Retry retry) {
        this.jsonStore = Objects.requireNonNull(jsonStore);
        this.key = Objects.requireNonNull(key);
        this.context = Objects.requireNonNull(context);
        this.entityClass = Objects.requireNonNull(entityClass);
        this.pollingIntervalMs = pollingIntervalMs;
        this.retryableConfigSupplier = Retry.decorateSupplier((Retry)Objects.requireNonNull(retry), this::reloadedConfigSupplier);
    }

    public PollingJsonStoreReloadableConfigContainer(JsonStore jsonStore, String key, String context, Class<T> entityClass) {
        this(jsonStore, key, context, entityClass, TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES), Retry.of((String)"retryReloading", (RetryConfig)RetryConfig.custom().maxAttempts(60).waitDuration(Duration.ofSeconds(5L)).build()));
    }

    public synchronized void reload() {
        ((Optional)Try.ofSupplier(this.retryableConfigSupplier).getOrElseThrow(t -> new RuntimeException((Throwable)t))).ifPresent(reloadedConfig -> {
            this.config = reloadedConfig;
        });
    }

    public T getConfig() {
        if (this.config == null || System.currentTimeMillis() > this.lastCheckedTime + this.pollingIntervalMs) {
            this.reload();
        }
        return this.config;
    }

    private Optional<T> reloadedConfigSupplier() {
        this.lastCheckedTime = System.currentTimeMillis();
        long lastUpdated = this.jsonStore.getLastUpdated(this.key, this.context).orElseThrow(PollingJsonStoreReloadableConfigContainer::failedToFind);
        if (lastUpdated <= this.lastGotTime) {
            return Optional.empty();
        }
        String jsonDocument = (String)this.jsonStore.get(this.key, this.context).orElseThrow(PollingJsonStoreReloadableConfigContainer::failedToFind);
        try {
            Object updatedConfig = this.mapper.readValue(jsonDocument, this.entityClass);
            this.lastGotTime = lastUpdated;
            return Optional.of(updatedConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException failedToFind() {
        throw new RuntimeException("Failed to find the configuration in the JSON store");
    }
}

