/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.retrieval.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.vavr.control.Either;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.opennms.core.concurrent.FutureUtils;
import org.opennms.features.deviceconfig.retrieval.api.Retriever;
import org.opennms.features.deviceconfig.sshscripting.SshScriptingService;
import org.opennms.features.deviceconfig.tftp.TftpFileReceiver;
import org.opennms.features.deviceconfig.tftp.TftpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieverImpl
implements Retriever,
AutoCloseable {
    private static Logger LOG = LoggerFactory.getLogger(RetrieverImpl.class);
    private static final Base64.Encoder BASE64_URL_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static String SCRIPT_VAR_FILENAME_SUFFIX = "filenameSuffix";
    private static String SCRIPT_VAR_TFTP_SERVER_PORT = "tftpServerPort";
    private static String SCRIPT_VAR_CONFIG_TYPE = "configType";
    final SshScriptingService sshScriptingService;
    private final TftpServer tftpServer;
    private final ExecutorService executor;

    public RetrieverImpl(SshScriptingService sshScriptingService, TftpServer tftpServer) {
        this.sshScriptingService = sshScriptingService;
        this.tftpServer = tftpServer;
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("device-config-retriever-%d").build());
    }

    @Override
    public CompletionStage<Either<Retriever.Failure, Retriever.Success>> retrieveConfig(Retriever.Protocol protocol, String script, String user, String password, String authKey, SocketAddress target, String hostKeyFingerprint, String shell, String configType, Map<String, String> vars, Duration timeout) {
        LOG.debug("retrieve config: " + String.valueOf(target));
        HashMap<String, String> vs = new HashMap<String, String>();
        vs.putAll(vars);
        String filenameSuffix = RetrieverImpl.uniqueFilenameSuffix();
        vs.put(SCRIPT_VAR_FILENAME_SUFFIX, filenameSuffix);
        vs.put(SCRIPT_VAR_TFTP_SERVER_PORT, String.valueOf(this.tftpServer.getPort()));
        vs.put(SCRIPT_VAR_CONFIG_TYPE, configType);
        if (protocol == Retriever.Protocol.TFTP) {
            Instant timeoutInstant = Instant.now().plus(timeout);
            TftpFileReceiverImpl tftpFileReceiver = new TftpFileReceiverImpl(target, filenameSuffix, () -> this.sshScriptingService.execute(script, user, password, authKey, target, hostKeyFingerprint, shell, (Map)vs, Duration.between(Instant.now(), timeoutInstant).minusSeconds(1L)));
            try {
                this.tftpServer.register((TftpFileReceiver)tftpFileReceiver);
                try {
                    return FutureUtils.completionStage(tftpFileReceiver::completeNowOrLater, (Duration)Duration.between(Instant.now(), timeoutInstant), tftpFileReceiver::onTimeout, (ExecutorService)this.executor).whenComplete((e, t) -> this.tftpServer.unregister((TftpFileReceiver)tftpFileReceiver));
                }
                catch (RuntimeException e2) {
                    this.tftpServer.unregister((TftpFileReceiver)tftpFileReceiver);
                    throw e2;
                }
            }
            catch (Exception e3) {
                String message = "could not trigger device config retrieval - target: " + String.valueOf(target);
                LOG.error(message, (Throwable)e3);
                return CompletableFuture.completedFuture(Either.left((Object)new Retriever.Failure(message)));
            }
        }
        String message = "unsupported protocol for device config retrieval - target: " + String.valueOf(target) + "; protocol: " + String.valueOf((Object)protocol);
        LOG.error(message);
        return CompletableFuture.completedFuture(Either.left((Object)new Retriever.Failure(message)));
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    static String scriptingFailureMsg(SocketAddress target, String msg) {
        return "could not trigger device config upload - target: " + String.valueOf(target) + "; msg: " + msg;
    }

    static String timeoutFailureMsg(SocketAddress target) {
        return "device config was not received in time. target: " + String.valueOf(target);
    }

    private static byte[] uuidToBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    private static String uniqueFilenameSuffix() {
        return BASE64_URL_ENCODER.encodeToString(RetrieverImpl.uuidToBytes(UUID.randomUUID())) + "-monitor";
    }

    private class TftpFileReceiverImpl
    implements TftpFileReceiver,
    FutureUtils.Completer<Either<Retriever.Failure, Retriever.Success>> {
        private final SocketAddress target;
        private final String fileNameSuffix;
        private final Supplier<SshScriptingService.Result> uploadTrigger;
        private CompletableFuture<SshScriptingService.Result> scriptFuture = null;
        private volatile CompletableFuture<Either<Retriever.Failure, Retriever.Success>> future;

        public TftpFileReceiverImpl(SocketAddress target, String filenameSuffix, Supplier<SshScriptingService.Result> uploadTrigger) {
            this.target = Objects.requireNonNull(target);
            this.fileNameSuffix = Objects.requireNonNull(filenameSuffix);
            this.uploadTrigger = uploadTrigger;
        }

        private void fail(String msg, Optional<String> stdout, Optional<String> stderr, String debug) {
            if (!this.future.isDone()) {
                LOG.error(msg);
                this.future.complete((Either<Retriever.Failure, Retriever.Success>)Either.left((Object)new Retriever.Failure(msg, stdout, stderr, debug)));
            } else {
                LOG.debug("TftpFileReceiverImpl attempting to fail an already completed future, msg \"{}\"- ignoring...", (Object)msg);
            }
        }

        public void completeNowOrLater(CompletableFuture<Either<Retriever.Failure, Retriever.Success>> future) {
            this.future = future;
            try {
                this.scriptFuture = CompletableFuture.supplyAsync(this.uploadTrigger);
                SshScriptingService.Result result = this.scriptFuture.get();
                if (result.isFailed()) {
                    this.fail(RetrieverImpl.scriptingFailureMsg(this.target, result.message), result.stdout, result.stderr, result.scriptOutput);
                }
            }
            catch (Throwable e) {
                String msg = RetrieverImpl.scriptingFailureMsg(this.target, e.getMessage());
                LOG.error(msg, e);
                this.fail(msg, Optional.empty(), Optional.empty(), RetrieverImpl.this.sshScriptingService.getScriptOutput());
            }
        }

        public void onTimeout(CompletableFuture<Either<Retriever.Failure, Retriever.Success>> future) {
            this.future = future;
            this.fail(RetrieverImpl.timeoutFailureMsg(this.target), Optional.empty(), Optional.empty(), RetrieverImpl.this.sshScriptingService.getScriptOutput());
        }

        public void onFileReceived(InetAddress address, String fileName, byte[] content) {
            if (fileName.endsWith(this.fileNameSuffix) && this.future != null) {
                LOG.debug("received config - target: " + String.valueOf(this.target) + "; address: " + address.getHostAddress());
                String scriptOutput = RetrieverImpl.this.sshScriptingService.getScriptOutput();
                if (this.scriptFuture != null && !this.scriptFuture.isDone()) {
                    try {
                        scriptOutput = this.scriptFuture.get((long)1L, (TimeUnit)TimeUnit.SECONDS).scriptOutput;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.future.complete((Either<Retriever.Failure, Retriever.Success>)Either.right((Object)new Retriever.Success(content, fileName.substring(0, fileName.length() - this.fileNameSuffix.length()), scriptOutput)));
            }
        }
    }
}

