/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.dao.support.ApplicationStatusUtil;
import org.opennms.netmgt.model.OnmsApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="perspectivepoller")
@Transactional
@Tag(name="PerspectivePoller", description="Perspective Poller API")
public class ApplicationStatusRestService {
    @Autowired
    private OutageDao outageDao;
    @Autowired
    private ApplicationDao applicationDao;
    @Autowired
    private MonitoredServiceDao monitoredServiceDao;

    @GET
    @Path(value="{applicationId}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a Status of a specified application", description="Get a Status of a specified application", operationId="ApplicationStatusRestServiceGetStatusByApplicationId")
    public Response applicationStatus(@PathParam(value="applicationId") Integer applicationId, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end) {
        OnmsApplication onmsApplication;
        if (end == null) {
            end = new Date().getTime();
        }
        if (start == null) {
            start = end - 86400000L;
        }
        if ((onmsApplication = (OnmsApplication)this.applicationDao.get((Serializable)applicationId)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Collection statusChanges = this.outageDao.getStatusChangesForApplicationIdBetween(new Date(start), new Date(end), applicationId);
        return Response.ok((Object)ApplicationStatusUtil.buildApplicationStatus((OnmsApplication)onmsApplication, (Collection)statusChanges, (long)start, (long)end)).build();
    }

    @GET
    @Path(value="{applicationId}/{monitoredServiceId}")
    @Produces(value={"application/json", "application/xml"})
    @Operation(summary="Get a Status of a specified application by monitoringServiceId", description="Get a Status of a specified application by monitoringServiceId", operationId="ApplicationStatusRestServiceGetStatusByMonitoringServiceId")
    public Response applicationServiceStatus(@PathParam(value="applicationId") Integer applicationId, @PathParam(value="monitoredServiceId") Integer monitoredServiceId, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end) {
        OnmsApplication onmsApplication;
        if (end == null) {
            end = new Date().getTime();
        }
        if (start == null) {
            start = end - 86400000L;
        }
        if ((onmsApplication = (OnmsApplication)this.applicationDao.get((Serializable)applicationId)) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Collection statusChanges = this.outageDao.getStatusChangesForApplicationIdBetween(new Date(start), new Date(end), applicationId);
        return Response.ok((Object)ApplicationStatusUtil.buildApplicationServiceStatus((MonitoredServiceDao)this.monitoredServiceDao, (OnmsApplication)onmsApplication, (Integer)monitoredServiceId, (Collection)statusChanges, (long)start, (long)end)).build();
    }
}

