/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.Serializable;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAcknowledgmentCollection;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.web.rest.support.SecurityHelper;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="acknowledgmentRestService")
@Path(value="acks")
public class AcknowledgmentRestService
extends OnmsRestService {
    @Autowired
    private AcknowledgmentDao m_ackDao;
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private NotificationDao m_notificationDao;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{id}")
    @Transactional
    public OnmsAcknowledgment getAcknowledgment(@PathParam(value="id") Integer acknowledgmentId) {
        OnmsAcknowledgment ack = (OnmsAcknowledgment)this.m_ackDao.get((Serializable)acknowledgmentId);
        if (ack == null) {
            throw AcknowledgmentRestService.getException(Response.Status.NOT_FOUND, "Acknowledgement object {} was not found.", Integer.toString(acknowledgmentId));
        }
        return ack;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_ackDao.countAll());
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public OnmsAcknowledgmentCollection getAcks(@Context UriInfo uriInfo) {
        CriteriaBuilder builder = AcknowledgmentRestService.getQueryFilters((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        OnmsAcknowledgmentCollection coll = new OnmsAcknowledgmentCollection((Collection)this.m_ackDao.findMatching(builder.toCriteria()));
        builder.clearOrder();
        builder.limit(null);
        builder.offset(null);
        coll.setTotalCount(Integer.valueOf(this.m_ackDao.countMatching(builder.toCriteria())));
        return coll;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response acknowledge(@Context SecurityContext securityContext, MultivaluedMap<String, String> formParams) {
        String alarmId = (String)formParams.getFirst((Object)"alarmId");
        String notifId = (String)formParams.getFirst((Object)"notifId");
        String action = (String)formParams.getFirst((Object)"action");
        String ackUser = (String)formParams.getFirst((Object)"ackUser");
        if (action == null) {
            action = "ack";
        }
        if (ackUser == null) {
            ackUser = securityContext.getUserPrincipal().getName();
        }
        SecurityHelper.assertUserEditCredentials(securityContext, ackUser);
        OnmsAcknowledgment ack = null;
        if (alarmId == null && notifId == null) {
            return this.getBadRequestResponse("You must supply either an alarmId or notifId");
        }
        if (alarmId != null && notifId != null) {
            return this.getBadRequestResponse("You cannot supply both an alarmId and a notifId");
        }
        if (alarmId != null) {
            Integer numericAlarmId = this.getNumericValue(alarmId);
            if (numericAlarmId == null) {
                return this.getBadRequestResponse("The alarmId has to be an integer value");
            }
            OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)numericAlarmId);
            if (alarm == null) {
                return Response.notModified().build();
            }
            ack = new OnmsAcknowledgment((Acknowledgeable)alarm, ackUser);
        } else if (notifId != null) {
            Integer numericNotifId = this.getNumericValue(notifId);
            if (numericNotifId == null) {
                return this.getBadRequestResponse("The notifId has to be an integer value");
            }
            OnmsNotification notification = (OnmsNotification)this.m_notificationDao.get((Serializable)numericNotifId);
            if (notification == null) {
                return Response.notModified().build();
            }
            ack = new OnmsAcknowledgment((Acknowledgeable)notification, ackUser);
        }
        if ("ack".equals(action)) {
            ack.setAckAction(AckAction.ACKNOWLEDGE);
        } else if ("unack".equals(action)) {
            ack.setAckAction(AckAction.UNACKNOWLEDGE);
        } else if ("clear".equals(action)) {
            ack.setAckAction(AckAction.CLEAR);
        } else if ("esc".equals(action)) {
            ack.setAckAction(AckAction.ESCALATE);
        } else {
            return this.getBadRequestResponse("Must supply the action parameter, set to either 'ack, 'unack', 'clear', or 'esc'");
        }
        this.m_ackDao.processAck(ack);
        return Response.ok(ack).build();
    }

    private static CriteriaBuilder getQueryFilters(MultivaluedMap<String, String> params) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsAcknowledgment.class);
        AcknowledgmentRestService.applyQueryFilters(params, builder);
        builder.orderBy("ackTime").desc();
        return builder;
    }
}

