/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import java.net.InetAddress;
import java.util.Date;
import java.util.function.Function;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.web.rest.support.CriteriaBehaviors;

public abstract class CriteriaValueConverters {
    public static final Function<String, Boolean> BOOLEAN_CONVERTER = new Function<String, Boolean>(){

        @Override
        public Boolean apply(String t) {
            return Boolean.parseBoolean(t);
        }

        public String toString() {
            return "BOOLEAN_CONVERTER";
        }
    };
    public static final Function<String, Date> DATE_CONVERTER = new Function<String, Date>(){

        @Override
        public Date apply(String t) {
            return CriteriaBehaviors.parseDate(t);
        }

        public String toString() {
            return "DATE_CONVERTER";
        }
    };
    public static final Function<String, Character> CHARACTER_CONVERTER = new Function<String, Character>(){

        @Override
        public Character apply(String t) {
            return Character.valueOf(t.charAt(0));
        }

        public String toString() {
            return "CHARACTER_CONVERTER";
        }
    };
    public static final Function<String, Float> FLOAT_CONVERTER = new Function<String, Float>(){

        @Override
        public Float apply(String t) {
            return Float.valueOf(Float.parseFloat(t));
        }

        public String toString() {
            return "FLOAT_CONVERTER";
        }
    };
    public static final Function<String, InetAddress> INET_ADDRESS_CONVERTER = new Function<String, InetAddress>(){

        @Override
        public InetAddress apply(String t) {
            return InetAddressUtils.addr((String)t);
        }

        public String toString() {
            return "INET_ADDRESS_CONVERTER";
        }
    };
    public static final Function<String, Integer> INT_CONVERTER = new Function<String, Integer>(){

        @Override
        public Integer apply(String t) {
            return Integer.parseInt(t);
        }

        public String toString() {
            return "INT_CONVERTER";
        }
    };
    public static final Function<String, Long> LONG_CONVERTER = new Function<String, Long>(){

        @Override
        public Long apply(String t) {
            return Long.parseLong(t);
        }

        public String toString() {
            return "LONG_CONVERTER";
        }
    };
    public static final Function<String, String> STRING_CONVERTER = new Function<String, String>(){

        @Override
        public String apply(String t) {
            return t;
        }

        public String toString() {
            return "STRING_CONVERTER";
        }
    };
}

