/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.opennms.setsequence;

import java.util.List;
import java.util.Map;
import java.util.Random;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.opennms.setsequence.SetSequenceStatement;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class SetSequenceGenerator
extends AbstractSqlGenerator<SetSequenceStatement> {
    private static final Logger LOG = LogService.getLog(SetSequenceGenerator.class);
    private final String m_tempTableName = "t" + Integer.toHexString(new Random().nextInt());

    public boolean supports(SetSequenceStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public String getTempTableName() {
        return this.m_tempTableName;
    }

    public ValidationErrors validate(SetSequenceStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("sequenceName", (Object)statement.getSequenceName());
        if (statement.getValue() == null) {
            validationErrors.checkRequiredField("table", statement.getTables());
        } else if (statement.getTables().size() > 0) {
            LOG.warning("You have set the sequence to a specific value, but have also provided tables to use for inferring the value.  Using the specific value.");
        }
        return validationErrors;
    }

    public Sql[] generateSql(SetSequenceStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT pg_catalog.setval(").append("'").append(statement.getSequenceName()).append("',");
        if (statement.getValue() != null) {
            sb.append(statement.getValue());
        } else {
            sb.append("(SELECT max(").append(this.m_tempTableName).append(".id)").append("+1").append(" AS id FROM (");
            List<String> tables = statement.getTables();
            Map<String, String> columns = statement.getColumns();
            int tableSize = tables.size();
            for (int i = 0; i < tableSize; ++i) {
                String tableName = tables.get(i);
                String columnName = columns.get(tableName);
                sb.append("(SELECT max(").append(columnName).append(") AS id FROM ");
                sb.append(tableName).append(" LIMIT 1)");
                if (i == tableSize - 1) continue;
                sb.append(" UNION ");
            }
            sb.append(")");
            sb.append(" AS ").append(this.m_tempTableName).append(" LIMIT 1)");
        }
        sb.append(",");
        sb.append("true");
        sb.append(");");
        return new Sql[]{new UnparsedSql(sb.toString(), new DatabaseObject[0])};
    }
}

