/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.opennms.createindex;

import liquibase.change.DatabaseChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.database.Database;
import liquibase.ext.opennms.createindex.CreateIndexWithWhereStatement;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateIndexStatement;

@DatabaseChange(name="createIndex", description="Creates an index on an existing column or set of columns.", priority=2, appliesTo={"index"})
public class CreateIndexWithWhereChange
extends CreateIndexChange {
    private static final Logger LOG = LogService.getLog(CreateIndexWithWhereChange.class);
    private String m_where;

    public String getWhere() {
        return this.m_where;
    }

    public void setWhere(String where) {
        this.m_where = where;
    }

    public SqlStatement[] generateStatements(Database database) {
        SqlStatement[] superStatements = super.generateStatements(database);
        if (this.m_where == null) {
            return superStatements;
        }
        if (superStatements.length != 1) {
            LOG.warning("expected 1 create index statement, but got " + superStatements.length);
            return superStatements;
        }
        return new SqlStatement[]{new CreateIndexWithWhereStatement((CreateIndexStatement)superStatements[0], this.m_where)};
    }
}

