/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapMappingGroup;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.VarbindMapping;
import org.opennms.netmgt.xml.event.Parm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@XmlRootElement(name="mapping")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SnmpTrapMapping {
    public static final Logger LOG = LoggerFactory.getLogger(SnmpTrapMappingGroup.class);
    @XmlAttribute(name="name", required=false)
    private String m_name;
    @XmlElement(name="rule", required=true)
    private String m_rule;
    @XmlElement(name="enterprise-oid", required=true)
    private String m_enterpriseOid;
    @XmlElement(name="generic", required=false, defaultValue="6")
    private Integer m_generic;
    @XmlElement(name="specific", required=false)
    private Integer m_specific;
    @XmlElement(name="varbind", required=true)
    private List<VarbindMapping> m_varbindMappings = new ArrayList<VarbindMapping>();

    public String getName() {
        return this.m_name;
    }

    public String getRule() {
        return this.m_rule;
    }

    public String getEnterpriseOid() {
        return this.m_enterpriseOid;
    }

    public Integer getGeneric() {
        return this.m_generic == null ? 6 : this.m_generic;
    }

    public Integer getSpecific() {
        return this.m_specific;
    }

    public List<VarbindMapping> getVarbindMappings() {
        return this.m_varbindMappings;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setRule(String rule) {
        this.m_rule = rule;
    }

    public void setEnterpriseOid(String enterpriseOid) {
        this.m_enterpriseOid = enterpriseOid;
    }

    public void setGeneric(Integer generic) {
        this.m_generic = generic;
    }

    public void setSpecific(Integer specific) {
        this.m_specific = specific;
    }

    public void setVarbindMappings(List<VarbindMapping> varbindMappings) {
        this.m_varbindMappings = varbindMappings;
    }

    public boolean accepts(NorthboundAlarm alarm) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)alarm);
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(this.getRule());
        boolean passed = false;
        try {
            passed = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            LOG.warn("mapping accepts: can't evaluate expression {} for alarm {} because: {}", new Object[]{this.getRule(), alarm.getUei(), e.getMessage()});
        }
        LOG.debug("mapping accepts: checking {} ? {}", (Object)this.getRule(), (Object)passed);
        return passed;
    }

    public List<Parm> getParams(NorthboundAlarm alarm) {
        ArrayList<Parm> parms = new ArrayList<Parm>();
        for (VarbindMapping vb : this.getVarbindMappings()) {
            Parm p = vb.getParameter(alarm);
            parms.add(p);
        }
        return parms;
    }
}

